/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.connection;

import de.cubeside.connection.ConnectionPlugin;
import de.cubeside.connection.GlobalClient;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.GlobalServer;
import de.cubeside.connection.event.GlobalDataEvent;
import de.cubeside.connection.event.GlobalPlayerDisconnectedEvent;
import de.cubeside.connection.event.GlobalPlayerJoinedEvent;
import de.cubeside.connection.event.GlobalServerConnectedEvent;
import de.cubeside.connection.event.GlobalServerDisconnectedEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

class GlobalClientBukkit
extends GlobalClient
implements Listener {
    private final ConnectionPlugin plugin;
    private boolean stoppingServer;

    public GlobalClientBukkit(ConnectionPlugin connectionPlugin, String host, int port, String account, String password) {
        super(host, port, account, password, false, connectionPlugin.getLogger());
        this.plugin = connectionPlugin;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.startThread();
        for (Player p : connectionPlugin.getServer().getOnlinePlayers()) {
            this.onPlayerOnline(p.getUniqueId(), p.getName(), System.currentTimeMillis());
        }
    }

    @Override
    protected void runInMainThread(Runnable r) {
        if (!this.stoppingServer) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, r);
        }
    }

    @Override
    protected void processData(GlobalServer source, String channel, GlobalPlayer targetPlayer, GlobalServer targetServer, byte[] data) {
        this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalDataEvent(source, targetPlayer, channel, data));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.onPlayerOnline(e.getPlayer().getUniqueId(), e.getPlayer().getName(), System.currentTimeMillis());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.onPlayerOffline(e.getPlayer().getUniqueId());
    }

    @Override
    protected void onPlayerJoined(GlobalServer server, GlobalPlayer player, boolean joinedTheNetwork) {
        this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalPlayerJoinedEvent(server, player, joinedTheNetwork));
    }

    @Override
    protected void onPlayerDisconnected(GlobalServer server, GlobalPlayer player, boolean leftTheNetwork) {
        this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalPlayerDisconnectedEvent(server, player, leftTheNetwork));
    }

    @Override
    protected void onServerConnected(GlobalServer server) {
        this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalServerConnectedEvent(server));
    }

    @Override
    protected void onServerDisconnected(GlobalServer server) {
        this.plugin.getServer().getPluginManager().callEvent((Event)new GlobalServerDisconnectedEvent(server));
    }

    protected void onServerStop() {
        this.stoppingServer = true;
    }
}

