/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.inventory.textinput.validator;

import de.feli490.feliutils.inventory.textinput.validator.TextValidator;

public class NumberTextValidator
implements TextValidator {
    private final String errorText;
    private final int minValue;
    private final int maxValue;

    public NumberTextValidator(String errorText) {
        this(errorText, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public NumberTextValidator(String errorText, int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.errorText = errorText;
    }

    @Override
    public boolean validate(String text) {
        try {
            int parsedValue = Integer.parseInt(text);
            return parsedValue >= this.minValue && parsedValue <= this.maxValue;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getErrorText() {
        return this.errorText;
    }
}

