/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.inventory.textinput;

import de.feli490.feliutils.inventory.ActionInventory;
import de.feli490.feliutils.inventory.textinput.TextInputInventoryContainer;
import de.feli490.feliutils.inventory.textinput.validator.TextValidator;
import de.feli490.feliutils.items.DefaultSkulls;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TextInputInventory {
    private final JavaPlugin javaPlugin;
    private final AnvilInventory anvilInventory;
    private final TextInputResult textInputResult;
    private final ActionInventory actionInventory;
    private final String confirmText;
    private final String notValidText;
    private final Set<TextValidator> textValidatorSet = new HashSet<TextValidator>();

    private TextInputInventory(JavaPlugin javaPlugin, AnvilInventory anvilInventory, TextInputResult textInputResult, String confirmText, String notValidText, ActionInventory actionInventory) {
        this.javaPlugin = javaPlugin;
        this.anvilInventory = anvilInventory;
        this.textInputResult = textInputResult;
        this.actionInventory = actionInventory;
        this.confirmText = confirmText;
        this.notValidText = notValidText;
    }

    public static TextInputInventory createTextInputInventory(JavaPlugin javaPlugin, HumanEntity humanEntity, TextInputResult textInputResult, String whatToDoTitle, Collection<String> whatTodoDescription, String confirmText, String notValidText) {
        return TextInputInventory.createTextInputInventory(javaPlugin, humanEntity, textInputResult, whatToDoTitle, whatTodoDescription, confirmText, notValidText, null);
    }

    public static TextInputInventory createTextInputInventory(JavaPlugin javaPlugin, HumanEntity humanEntity, TextInputResult textInputResult, String whatToDoTitle, Collection<String> whatTodoDescription, String confirmText, String notValidText, ActionInventory actionInventory) {
        ItemStack itemStack = DefaultSkulls.QUESTION_MARK.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(whatToDoTitle);
        ArrayList<String> lore = new ArrayList<String>(whatTodoDescription);
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        InventoryView inventoryView = humanEntity.openAnvil(humanEntity.getLocation(), true);
        AnvilInventory anvilInventory = (AnvilInventory)inventoryView.getTopInventory();
        anvilInventory.setFirstItem(itemStack);
        anvilInventory.setMaximumRepairCost(0);
        TextInputInventory textInputInventory = new TextInputInventory(javaPlugin, anvilInventory, textInputResult, confirmText, notValidText, actionInventory);
        TextInputInventoryContainer.getInstance().addTextInputInventory(textInputInventory);
        return textInputInventory;
    }

    public ActionInventory getActionInventory() {
        return this.actionInventory;
    }

    public TextInputResult getTextInputResult() {
        return this.textInputResult;
    }

    public AnvilInventory getAnvilInventory() {
        return this.anvilInventory;
    }

    public ItemStack getResultItemStack(String newText) {
        Set<TextValidator> failedValidators = this.validate(newText);
        ItemStack itemStack = failedValidators.isEmpty() ? this.confirmItemStack() : this.notValidItemStack(failedValidators);
        return itemStack;
    }

    public void confirmClick() {
        if (!this.validate().isEmpty()) {
            return;
        }
        String renameText = this.getRenameText();
        this.closeInventory();
        this.javaPlugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.javaPlugin, () -> this.textInputResult.textResult(renameText), 1L);
    }

    private void closeInventory() {
        this.clearInventory();
        this.anvilInventory.close();
    }

    public void clearInventory() {
        this.anvilInventory.clear();
    }

    public void addTextValidator(TextValidator textValidator) {
        this.textValidatorSet.add(textValidator);
    }

    private ItemStack confirmItemStack() {
        ItemStack itemStack = DefaultSkulls.GREEN_CHECKMARK.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(MessageFormat.format("{0}{1}", ChatColor.GREEN, this.confirmText));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private ItemStack notValidItemStack(Set<TextValidator> failedValidators) {
        ItemStack itemStack = DefaultSkulls.RED_CROSS.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(MessageFormat.format("{0}{1}", ChatColor.RED, this.notValidText));
        ArrayList lore = new ArrayList();
        failedValidators.forEach(textValidator -> lore.add(MessageFormat.format("{0} - {1}", ChatColor.WHITE, textValidator.getErrorText())));
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private Set<TextValidator> validate() {
        return this.validate(this.getRenameText());
    }

    private Set<TextValidator> validate(String renameText) {
        HashSet<TextValidator> failedValidators = new HashSet<TextValidator>();
        for (TextValidator textValidator : this.textValidatorSet) {
            if (textValidator.validate(renameText)) continue;
            failedValidators.add(textValidator);
        }
        return failedValidators;
    }

    private String getRenameText() {
        String renameText = this.anvilInventory.getRenameText();
        if (renameText == null) {
            renameText = "";
        }
        return renameText;
    }

    public static interface TextInputResult {
        public void textResult(String var1);
    }
}

