/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.inventory.textinput.validator;

import de.feli490.feliutils.inventory.textinput.validator.TextValidator;

public class DoubleTextValidator
implements TextValidator {
    private final double minValue;
    private final double maxValue;
    private final String errorText;

    public DoubleTextValidator(String errorText) {
        this(errorText, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public DoubleTextValidator(String errorText, double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.errorText = errorText;
    }

    @Override
    public boolean validate(String text) {
        try {
            double parsedValue = Double.parseDouble(text);
            return parsedValue >= this.minValue && parsedValue <= this.maxValue;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getErrorText() {
        return this.errorText;
    }
}

