/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageSplitter<T> {
    private final List<T> list;
    private final int pageEntries;

    public PageSplitter(Collection<T> list, int pageEntries) {
        this.list = new ArrayList<T>(list);
        this.pageEntries = pageEntries;
    }

    public void sort(Comparator<T> comparator) {
        this.list.sort(comparator);
    }

    public boolean isValidPage(int page) {
        if (page < 0) {
            return false;
        }
        return page <= this.getMaxPage() - 1;
    }

    public Map<Integer, List<T>> getPages() {
        HashMap<Integer, List<T>> pages = new HashMap<Integer, List<T>>();
        int maxPage = this.getMaxPage();
        for (int page = 0; page < maxPage; ++page) {
            ArrayList<T> pageList = new ArrayList<T>();
            for (int i = 0; i < this.pageEntries && page * this.pageEntries + i < this.list.size(); ++i) {
                pageList.add(this.list.get(page * this.pageEntries + i));
            }
            pages.put(page, pageList);
        }
        return pages;
    }

    public int getMaxPage() {
        return (this.list.size() - 1) / this.pageEntries + 1;
    }

    public List<T> getPageContent(int page) {
        return this.getPages().get(page);
    }
}

