/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.search;

import de.feli490.feliutils.search.parameters.identifier.ParameterIdentifier;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ParameterIdentifierContainer {
    private final Map<String, ParameterIdentifier<?>> parameters = new HashMap();

    public void registerIdentifier(ParameterIdentifier<?> parameterIdentifier) {
        if (this.isIdentifierRegistered(parameterIdentifier)) {
            throw new IllegalArgumentException(MessageFormat.format("Ein Parameter mit der ID {0} ist bereits registriert.", parameterIdentifier.getParameterID()));
        }
        this.parameters.put(parameterIdentifier.getParameterID(), parameterIdentifier);
    }

    public Collection<String> getParameterIDs() {
        return this.parameters.keySet();
    }

    public boolean isIdentifierRegistered(ParameterIdentifier<?> parameterIdentifier) {
        return this.parameters.containsKey(parameterIdentifier.getParameterID());
    }

    public void unregisterIdentifier(ParameterIdentifier<?> parameterIdentifier) {
        if (!this.isIdentifierRegistered(parameterIdentifier)) {
            throw new IllegalArgumentException(MessageFormat.format("Ein Parameter mit der ID {0} ist nicht registriert.", parameterIdentifier.getParameterID()));
        }
        this.parameters.remove(parameterIdentifier.getParameterID());
    }

    public ParameterIdentifier<?> getParameterIdentifier(String key) {
        return this.parameters.get(key.toLowerCase(Locale.ENGLISH));
    }
}

