/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.inventory;

import de.feli490.feliutils.inventory.ActionInventoryClickEvent;
import de.feli490.feliutils.inventory.ActionInventoryCloseEvent;
import de.feli490.feliutils.inventory.ActionInventoryOpenEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ActionInventory
implements InventoryHolder {
    private final Map<Integer, ActionInventoryClickEvent> clickActions = new HashMap<Integer, ActionInventoryClickEvent>();
    private final Map<Integer, ActionInventoryClickEvent> clickPlayerInventoryActions = new HashMap<Integer, ActionInventoryClickEvent>();
    private final Set<ActionInventoryOpenEvent> openActions = new HashSet<ActionInventoryOpenEvent>();
    private final Set<ActionInventoryCloseEvent> closeActions = new HashSet<ActionInventoryCloseEvent>();
    private final Set<ActionInventoryClickEvent> generalClickActions = new HashSet<ActionInventoryClickEvent>();
    private final boolean closeOnClick;
    private Inventory inv;

    private ActionInventory(boolean closeOnClick) {
        this.closeOnClick = closeOnClick;
    }

    public static ActionInventory createActionInventory(boolean closeOnClick, int size) {
        ActionInventory headcaseActionInventory = new ActionInventory(closeOnClick);
        Inventory inv = Bukkit.createInventory((InventoryHolder)headcaseActionInventory, (int)size);
        headcaseActionInventory.setInv(inv);
        return headcaseActionInventory;
    }

    public static ActionInventory createActionInventory(boolean closeOnClick, InventoryType inventoryType) {
        ActionInventory headcaseActionInventory = new ActionInventory(closeOnClick);
        Inventory inv = Bukkit.createInventory((InventoryHolder)headcaseActionInventory, (InventoryType)inventoryType);
        headcaseActionInventory.setInv(inv);
        return headcaseActionInventory;
    }

    public static ActionInventory createActionInventory(boolean closeOnClick, int size, String title) {
        ActionInventory headcaseActionInventory = new ActionInventory(closeOnClick);
        Inventory inv = Bukkit.createInventory((InventoryHolder)headcaseActionInventory, (int)size, (String)title);
        headcaseActionInventory.setInv(inv);
        return headcaseActionInventory;
    }

    public static ActionInventory createActionInventory(boolean closeOnClick, InventoryType inventoryType, String title) {
        ActionInventory headcaseActionInventory = new ActionInventory(closeOnClick);
        Inventory inv = Bukkit.createInventory((InventoryHolder)headcaseActionInventory, (InventoryType)inventoryType, (String)title);
        headcaseActionInventory.setInv(inv);
        return headcaseActionInventory;
    }

    public void registerOpenActions(ActionInventoryOpenEvent actionInventoryOpenEvent) {
        this.openActions.add(actionInventoryOpenEvent);
    }

    public void unregisterOpenActions(ActionInventoryOpenEvent actionInventoryOpenEvent) {
        this.openActions.add(actionInventoryOpenEvent);
    }

    public void registerCloseActions(ActionInventoryCloseEvent actionInventoryCloseEvent) {
        this.closeActions.add(actionInventoryCloseEvent);
    }

    public void unregisterCloseActions(ActionInventoryCloseEvent actionInventoryCloseEvent) {
        this.closeActions.add(actionInventoryCloseEvent);
    }

    public void registerClickActions(ActionInventoryClickEvent actionInventoryClickEvent) {
        this.generalClickActions.add(actionInventoryClickEvent);
    }

    public void unregisterClickActions(ActionInventoryClickEvent actionInventoryClickEvent) {
        this.generalClickActions.add(actionInventoryClickEvent);
    }

    public void setClickEvent(int slot, ActionInventoryClickEvent actionInventoryClickEvent) {
        this.clickActions.put(slot, actionInventoryClickEvent);
    }

    public void unregisterSlot(int slot) {
        this.clickActions.remove(slot);
    }

    public void setPlayerInventoryClickEvent(int slot, ActionInventoryClickEvent actionInventoryClickEvent) {
        this.clickPlayerInventoryActions.put(slot, actionInventoryClickEvent);
    }

    public void unregisterPlayerInventorySlot(int slot) {
        this.clickPlayerInventoryActions.remove(slot);
    }

    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        for (ActionInventoryCloseEvent closeAction : this.closeActions) {
            closeAction.onAction(inventoryCloseEvent);
        }
    }

    public void onInventoryOpen(InventoryOpenEvent inventoryOpenEvent) {
        for (ActionInventoryOpenEvent openAction : this.openActions) {
            openAction.onAction(inventoryOpenEvent);
        }
    }

    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        int slot = inventoryClickEvent.getSlot();
        if (this.clickActions.containsKey(slot)) {
            this.clickActions.get(slot).onAction(inventoryClickEvent);
        }
    }

    public void onPlayerInventoryClick(InventoryClickEvent inventoryClickEvent) {
        int slot = inventoryClickEvent.getSlot();
        if (this.clickPlayerInventoryActions.containsKey(slot)) {
            this.clickPlayerInventoryActions.get(slot).onAction(inventoryClickEvent);
        }
    }

    public void onClick(InventoryClickEvent inventoryClickEvent) {
        this.generalClickActions.forEach(actionInventoryClickEvent -> actionInventoryClickEvent.onAction(inventoryClickEvent));
    }

    public boolean closeOnClick() {
        return this.closeOnClick;
    }

    public Inventory getInventory() {
        return this.inv;
    }

    private void setInv(Inventory inv) {
        this.inv = inv;
    }
}

