/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.search.query.expressions;

import de.feli490.feliutils.search.query.expressions.basic.factories.AbstractBasicExpressionFactory;
import de.feli490.feliutils.search.query.expressions.basic.factories.EqualsBasicExpressionFactory;
import de.feli490.feliutils.search.query.expressions.basic.factories.LikeBasicExpressionFactory;
import de.feli490.feliutils.search.query.expressions.logic.factories.AbstractLogicExpressionFactory;
import de.feli490.feliutils.search.query.expressions.logic.factories.AndLogicExpressionFactory;
import de.feli490.feliutils.search.query.expressions.logic.factories.OrLogicExpressionFactory;
import de.feli490.feliutils.search.query.expressions.logic.factories.XOrLogicExpressionFactory;
import java.util.HashMap;
import java.util.Map;

public class ExpressionSymbols {
    private static final Map<String, AbstractBasicExpressionFactory> BASIC_SYMBOL_EXPRESSION_MAP = new HashMap<String, AbstractBasicExpressionFactory>();
    private static final Map<String, AbstractLogicExpressionFactory> LOGIC_SYMBOL_EXPRESSION_MAP = new HashMap<String, AbstractLogicExpressionFactory>();

    public static Map<String, AbstractBasicExpressionFactory> getBasicExpressionFactorySymbols() {
        return new HashMap<String, AbstractBasicExpressionFactory>(BASIC_SYMBOL_EXPRESSION_MAP);
    }

    public static AbstractBasicExpressionFactory getBasicExpressionFactory(String symbol) {
        return BASIC_SYMBOL_EXPRESSION_MAP.get(symbol);
    }

    public static Map<String, AbstractLogicExpressionFactory> getLogicExpressionFactorySymbols() {
        return new HashMap<String, AbstractLogicExpressionFactory>(LOGIC_SYMBOL_EXPRESSION_MAP);
    }

    public static AbstractLogicExpressionFactory getLogicExpressionFactory(String symbol) {
        return LOGIC_SYMBOL_EXPRESSION_MAP.get(symbol);
    }

    static {
        BASIC_SYMBOL_EXPRESSION_MAP.put("=", new EqualsBasicExpressionFactory());
        BASIC_SYMBOL_EXPRESSION_MAP.put("~", new LikeBasicExpressionFactory());
        LOGIC_SYMBOL_EXPRESSION_MAP.put("and", new AndLogicExpressionFactory());
        LOGIC_SYMBOL_EXPRESSION_MAP.put("or", new OrLogicExpressionFactory());
        LOGIC_SYMBOL_EXPRESSION_MAP.put("xor", new XOrLogicExpressionFactory());
    }
}

