/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.items;

import de.iani.cubesideutils.MathUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.HangingSign;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.WallHangingSign;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;

public class SignUtils {
    private SignUtils() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static Side getFacingSignSide(Entity entity, Block sign) {
        BlockData data = sign.getBlockData();
        Material type = data.getMaterial();
        BlockFace signFace = null;
        double centerx = 0.5;
        double centerz = 0.5;
        double yRotationDegree = 0.0;
        if (type.data == Sign.class || type.data == HangingSign.class) {
            Rotatable rotatableData = (Rotatable)data;
            signFace = rotatableData.getRotation();
            if (signFace == BlockFace.SOUTH) {
                yRotationDegree = 0.0;
            } else if (signFace == BlockFace.SOUTH_SOUTH_WEST) {
                yRotationDegree = 22.5;
            } else if (signFace == BlockFace.SOUTH_WEST) {
                yRotationDegree = 45.0;
            } else if (signFace == BlockFace.WEST_SOUTH_WEST) {
                yRotationDegree = 67.5;
            } else if (signFace == BlockFace.WEST) {
                yRotationDegree = 90.0;
            } else if (signFace == BlockFace.WEST_NORTH_WEST) {
                yRotationDegree = 112.5;
            } else if (signFace == BlockFace.NORTH_WEST) {
                yRotationDegree = 135.0;
            } else if (signFace == BlockFace.NORTH_NORTH_WEST) {
                yRotationDegree = 157.5;
            } else if (signFace == BlockFace.NORTH) {
                yRotationDegree = 180.0;
            } else if (signFace == BlockFace.NORTH_NORTH_EAST) {
                yRotationDegree = 202.5;
            } else if (signFace == BlockFace.NORTH_EAST) {
                yRotationDegree = 225.0;
            } else if (signFace == BlockFace.EAST_NORTH_EAST) {
                yRotationDegree = 247.5;
            } else if (signFace == BlockFace.EAST) {
                yRotationDegree = 270.0;
            } else if (signFace == BlockFace.EAST_SOUTH_EAST) {
                yRotationDegree = 292.5;
            } else if (signFace == BlockFace.SOUTH_EAST) {
                yRotationDegree = 315.0;
            } else if (signFace == BlockFace.SOUTH_SOUTH_EAST) {
                yRotationDegree = 337.5;
            }
        } else if (type.data == WallSign.class || type.data == WallHangingSign.class) {
            Directional directionalData = (Directional)data;
            signFace = directionalData.getFacing();
            if (signFace == BlockFace.SOUTH) {
                yRotationDegree = 0.0;
            } else if (signFace == BlockFace.WEST) {
                yRotationDegree = 90.0;
            } else if (signFace == BlockFace.NORTH) {
                yRotationDegree = 180.0;
            } else if (signFace == BlockFace.EAST) {
                yRotationDegree = 270.0;
            }
            if (type.data == WallSign.class) {
                if (signFace == BlockFace.NORTH) {
                    centerz = 0.9375;
                } else if (signFace == BlockFace.SOUTH) {
                    centerz = 0.0625;
                } else if (signFace == BlockFace.WEST) {
                    centerx = 0.9375;
                } else if (signFace == BlockFace.EAST) {
                    centerx = 0.0625;
                }
            }
        } else {
            throw new IllegalArgumentException("block is not a sign");
        }
        Location entityLoc = entity.getLocation();
        double relativeX = entityLoc.getX() - ((double)sign.getX() + centerx);
        double relativeZ = entityLoc.getZ() - ((double)sign.getZ() + centerz);
        double f = Math.atan2(relativeZ, relativeX) * 180.0 / Math.PI - 90.0;
        return Math.abs(MathUtil.warpDegrees(f - yRotationDegree)) <= 90.0 ? Side.FRONT : Side.BACK;
    }
}

