/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import com.google.common.base.Objects;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.event.GlobalPlayerJoinedEvent;
import de.iani.cubesideutils.bukkit.events.PlayerMadeUnknownActionEvent;
import de.iani.cubesideutils.bukkit.plugin.AnvilGUI;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.OnlinePlayerDataImpl;
import de.iani.cubesideutils.bukkit.plugin.PlayerDataImplBukkit;
import de.iani.cubesideutils.bukkit.plugin.UtilsGlobalDataHelperBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.events.PlayerPermissionsChangedEvent;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.Plugin;

public final class EventListener
implements Listener {
    private CubesideUtilsBukkit core = CubesideUtilsBukkit.getInstance();

    public EventListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.core.getPlugin());
    }

    private void madeAction(Player player) {
        if (!player.isOnline()) {
            return;
        }
        PlayerDataImplBukkit data = (PlayerDataImplBukkit)this.core.getPlayerDataCache().get(player.getUniqueId());
        if (!data.isOnlineHere()) {
            return;
        }
        OnlinePlayerDataImpl onlineData = data.getOnlineData();
        if (onlineData == null) {
            return;
        }
        onlineData.madeAction();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerLoginEvent(PlayerLoginEvent event) {
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        this.core.getPlayerData(event.getPlayer()).checkRank();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLoginEarly(PlayerLoginEvent event) {
        String hostName = event.getHostname();
        int split = hostName.indexOf(0);
        if (split >= 0) {
            hostName = hostName.substring(0, split);
        }
        this.core.getPlayerData(event.getPlayer()).setHostName(hostName);
    }

    @EventHandler
    public void onPlayerPermissionsChanged(PlayerPermissionsChangedEvent event) {
        Player player = Bukkit.getPlayer((UUID)event.getPlayerId());
        if (player == null) {
            return;
        }
        this.core.getPlayerData(player).checkRank();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onGlobalPlayerJoinedEvent(GlobalPlayerJoinedEvent event) {
        if (!event.hasJustJoinedTheNetwork()) {
            return;
        }
        GlobalPlayer player = event.getPlayer();
        PlayerDataImplBukkit data = this.core.getPlayerDataCache().get(player.getUniqueId(), true, true);
        if (data.getFirstJoin() == 0L) {
            data.setNameAndFirstJoinAndLastJoinAndSeen(System.currentTimeMillis(), player.getName());
        } else {
            data.setNameAndLastJoinAndSeen(System.currentTimeMillis(), player.getName());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        UtilsGlobalDataHelperBukkit globalData = this.core.getGlobalDataHelper();
        globalData.setPropertyValue((OfflinePlayer)event.getPlayer(), "worldDisplayName:" + globalData.getThisServerName(), this.core.getWorldDisplayName((LivingEntity)event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerChangedWorldEvent(PlayerChangedWorldEvent event) {
        UtilsGlobalDataHelperBukkit globalData = this.core.getGlobalDataHelper();
        globalData.setPropertyValue((OfflinePlayer)event.getPlayer(), "worldDisplayName:" + globalData.getThisServerName(), this.core.getWorldDisplayName((LivingEntity)event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        UtilsGlobalDataHelperBukkit globalData = this.core.getGlobalDataHelper();
        globalData.setPropertyValue((OfflinePlayer)event.getPlayer(), "worldDisplayName:" + globalData.getThisServerName(), null);
        this.core.getPlayerData(event.getPlayer()).setLastSeen(System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onAsynchPlayerChatEvent(AsyncChatEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void PlayerPlayerDropItemEvent(PlayerDropItemEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerEditBookEvent(PlayerEditBookEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerInteractAtEntityEvent(PlayerInteractAtEntityEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerItemHeldEvent(PlayerItemHeldEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerMoveEvent(PlayerMoveEvent event) {
        if (event.getFrom().getPitch() != event.getTo().getPitch() || event.getFrom().getYaw() != event.getTo().getYaw()) {
            this.madeAction(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerInputEvent(PlayerInputEvent event) {
        if (event.getInput().isForward() || event.getInput().isBackward() || event.getInput().isLeft() || event.getInput().isRight() || event.getInput().isJump()) {
            this.madeAction(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerSwapHandItemsEvent(PlayerSwapHandItemsEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        this.madeAction((Player)event.getWhoClicked());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        this.madeAction((Player)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        this.madeAction((Player)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMadeAnyAction(PlayerMadeUnknownActionEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler
    public void onPlayerInventoryClick(InventoryClickEvent e) {
        Player player;
        AnvilGUI anvil;
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player && (anvil = this.core.getPlayerData(player = (Player)humanEntity).getOpenAnvilGUI()) != null && Objects.equal((Object)anvil.getOpenInventory(), (Object)e.getView())) {
            e.setCancelled(true);
            if (e.getClickedInventory() instanceof AnvilInventory) {
                anvil.onInventoryClick(e.getSlot(), e.getCurrentItem(), e.isShiftClick());
            }
        }
    }

    @EventHandler
    public void onPlayerPrepareResult(PrepareResultEvent e) {
        if (e.getView() instanceof AnvilView) {
            for (HumanEntity viewer : e.getViewers()) {
                Player player;
                AnvilGUI anvil;
                if (!(viewer instanceof Player) || (anvil = this.core.getPlayerData(player = (Player)viewer).getOpenAnvilGUI()) == null || !Objects.equal((Object)anvil.getOpenInventory(), (Object)e.getView())) continue;
                anvil.onUpdateAnvil(e);
            }
        }
    }

    @EventHandler
    public void onPlayerCloseInventory(InventoryCloseEvent e) {
        Player player;
        AnvilGUI anvil;
        HumanEntity humanEntity;
        if (e.getView() instanceof AnvilView && (humanEntity = e.getPlayer()) instanceof Player && (anvil = this.core.getPlayerData(player = (Player)humanEntity).getOpenAnvilGUI()) != null && Objects.equal((Object)anvil.getOpenInventory(), (Object)e.getView())) {
            anvil.onInventoryClose();
        }
    }
}

