/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.iani.cubesideutils.plugin.CubesideUtils;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class GeneralDataCache {
    private CubesideUtils core = CubesideUtils.getInstance();
    private Map<String, String> cache = new HashMap<String, String>();

    public synchronized String get(String key) throws SQLException {
        try {
            return this.cache.computeIfAbsent(key, k -> {
                try {
                    return this.core.getDatabase().getGeneralData((String)k);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    public synchronized void set(String key, String value) throws SQLException {
        if (key.length() > 127) {
            throw new IllegalArgumentException("key is too long");
        }
        this.core.getDatabase().setGeneralData(key, value);
        this.core.getGlobalDataHelper().sendData(UtilsGlobalDataHelper.MessageType.GENERAL_DATA_CHANGED, key);
        this.cache.put(key, value);
    }

    public synchronized void invalidate(String key) {
        this.cache.remove(key);
    }
}

