/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bungee;

import de.iani.cubesideutils.ChatUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class ChatUtilsBungee {
    private ChatUtilsBungee() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static List<ChatUtil.Sendable<CommandSender>> stringToSendableList(List<String> messages) {
        ArrayList<ChatUtil.Sendable<CommandSender>> result = new ArrayList<ChatUtil.Sendable<CommandSender>>(messages.size());
        for (String msg : messages) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<ChatUtil.Sendable<CommandSender>> bcToSendableList(List<BaseComponent[]> messages) {
        ArrayList<ChatUtil.Sendable<CommandSender>> result = new ArrayList<ChatUtil.Sendable<CommandSender>>(messages.size());
        for (BaseComponent[] msg : messages) {
            result.add(new ComponentMsg(msg));
        }
        return result;
    }

    private static List<ChatUtil.Sendable<ChatUtil.MessageReceiver>> convertSendableList(final List<? extends BungeeSendable> messages) {
        return new AbstractList<ChatUtil.Sendable<ChatUtil.MessageReceiver>>(){

            @Override
            public ChatUtil.Sendable<ChatUtil.MessageReceiver> get(int index) {
                return ((BungeeSendable)messages.get(index)).toGenericSendable();
            }

            @Override
            public int size() {
                return messages.size();
            }
        };
    }

    protected static void sendMessagesPaged(CommandSender recipient, List<? extends BungeeSendable> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtilsBungee.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    protected static void sendMessagesPaged(CommandSender recipient, List<? extends BungeeSendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtilsBungee.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    protected static void sendMessagesPaged(CommandSender recipient, List<? extends BungeeSendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(new CommandSenderWrapper(recipient), ChatUtilsBungee.convertSendableList(messages), page, name, openPageCommandPrefix, pluginPrefix, normalColor, warningColor);
    }

    public static class StringMsg
    implements BungeeSendable {
        public final String message;

        public StringMsg(String message) {
            this.message = message;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.message);
        }

        @Override
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable() {
            return new ChatUtil.StringMsg(this.message);
        }
    }

    public static class ComponentMsg
    implements BungeeSendable {
        public final BaseComponent[] message;

        public ComponentMsg(BaseComponent ... message) {
            this.message = message;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.message);
        }

        @Override
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable() {
            return new ChatUtil.BaseComponentMsg(this.message);
        }
    }

    public static class CommandSenderWrapper
    implements ChatUtil.MessageReceiver {
        private final CommandSender original;

        public CommandSenderWrapper(CommandSender original) {
            this.original = original;
        }

        @Override
        public void sendMessage(String message) {
            this.original.sendMessage(message);
        }

        @Override
        public void sendMessage(BaseComponent ... message) {
            this.original.sendMessage(message);
        }

        @Override
        public void sendMessage(Component message) {
            this.sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.gson().serialize(message))));
        }
    }

    public static interface BungeeSendable
    extends ChatUtil.Sendable<CommandSender> {
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable();
    }
}

