/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.bukkit.ChatUtilBukkit;
import de.iani.cubesideutils.bukkit.commands.CommandRouter;
import de.iani.cubesideutils.bukkit.conditions.HasCustomPlayerDataValueCondition;
import de.iani.cubesideutils.bukkit.conditions.HasPermissionCondition;
import de.iani.cubesideutils.bukkit.inventory.WindowManager;
import de.iani.cubesideutils.bukkit.plugin.AfkManager;
import de.iani.cubesideutils.bukkit.plugin.AnvilGUI;
import de.iani.cubesideutils.bukkit.plugin.EventListener;
import de.iani.cubesideutils.bukkit.plugin.InventoryInputManagerImpl;
import de.iani.cubesideutils.bukkit.plugin.OnlinePlayerDataImpl;
import de.iani.cubesideutils.bukkit.plugin.PlayerDataCache;
import de.iani.cubesideutils.bukkit.plugin.PlayerDataImplBukkit;
import de.iani.cubesideutils.bukkit.plugin.PlayerReconfigurationPhaseHelper;
import de.iani.cubesideutils.bukkit.plugin.PlayerUUIDCacheWrapper;
import de.iani.cubesideutils.bukkit.plugin.UtilsDatabaseBukkit;
import de.iani.cubesideutils.bukkit.plugin.UtilsGlobalDataHelperBukkit;
import de.iani.cubesideutils.bukkit.plugin.UtilsPluginBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.UtilsApiBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.events.PlayerOptionsRetrievedEvent;
import de.iani.cubesideutils.bukkit.plugin.commands.ChangeRankInformationCommand;
import de.iani.cubesideutils.bukkit.plugin.commands.ListRankInformationCommand;
import de.iani.cubesideutils.bukkit.plugin.commands.PlayerOptionsCommand;
import de.iani.cubesideutils.bukkit.serialization.GlobalLocationWrapper;
import de.iani.cubesideutils.bukkit.serialization.SerializableComponent;
import de.iani.cubesideutils.bukkit.serialization.SerializablePair;
import de.iani.cubesideutils.bukkit.serialization.SerializableTriple;
import de.iani.cubesideutils.bukkit.sound.SoundSequence;
import de.iani.cubesideutils.bukkit.sql.SQLConfigBukkit;
import de.iani.cubesideutils.conditions.Condition;
import de.iani.cubesideutils.plugin.CubesideUtils;
import de.iani.cubesideutils.plugin.PlayerDataImpl;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import de.iani.cubesideutils.serialization.NullWrapper;
import de.iani.cubesideutils.serialization.StringSerialization;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CubesideUtilsBukkit
extends CubesideUtils
implements UtilsApiBukkit {
    public static final String DISPLAY_NAME_PROPERTY_PREFIX = "worldDisplayName:";
    public static final String RANKS_COMMAND = "ranks";
    public static final String PLAYEROPTIONS_COMMAND = "playeroptions";
    private static volatile CubesideUtilsBukkit instance = null;
    private UtilsPluginBukkit plugin;
    private UtilsDatabaseBukkit database;
    private PlayerDataCache playerDataCache;
    private PlayerUUIDCacheWrapper playerUUIDCache;
    private GlobalClientPlugin globalClientPlugin;
    private UtilsGlobalDataHelperBukkit globalDataHelper;
    private InventoryInputManagerImpl inventoryInputManager;
    private PlayerReconfigurationPhaseHelper reconfigurationPhaseHelper;
    private String defaultDisplayName;
    private Map<String, String> worldDisplayNames;

    public static CubesideUtilsBukkit getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CubesideUtilsBukkit(UtilsPluginBukkit plugin) {
        Class<CubesideUtilsBukkit> clazz = CubesideUtilsBukkit.class;
        synchronized (CubesideUtilsBukkit.class) {
            if (instance != null) {
                throw new IllegalStateException("Only one instance permitted.");
            }
            instance = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.plugin = plugin;
            return;
        }
    }

    @Override
    protected void onEnableInternal() throws Throwable {
        this.plugin.saveDefaultConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.defaultDisplayName = config.getString("defaultDisplayName");
        this.worldDisplayNames = new LinkedHashMap<String, String>();
        ConfigurationSection displayNamesSection = config.getConfigurationSection("worldDisplayNames");
        for (String worldName : displayNamesSection.getKeys(false)) {
            this.worldDisplayNames.put(worldName, displayNamesSection.getString(worldName));
        }
        this.database = new UtilsDatabaseBukkit(new SQLConfigBukkit(config.getConfigurationSection("database")));
        this.playerDataCache = new PlayerDataCache();
        new EventListener();
        new AfkManager();
        new WindowManager();
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("PlayerUUIDCache")) {
            this.playerUUIDCache = new PlayerUUIDCacheWrapper((Plugin)this.plugin);
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("GlobalClient")) {
            this.globalClientPlugin = (GlobalClientPlugin)JavaPlugin.getPlugin(GlobalClientPlugin.class);
            this.globalDataHelper = new UtilsGlobalDataHelperBukkit(this.plugin);
        }
        this.inventoryInputManager = new InventoryInputManagerImpl();
        this.reconfigurationPhaseHelper = new PlayerReconfigurationPhaseHelper();
        this.database.registerRealServer();
        CommandRouter ranksCommand = new CommandRouter(this.plugin.getCommand(RANKS_COMMAND));
        ranksCommand.addCommandMapping(new ListRankInformationCommand(), "list");
        ranksCommand.addCommandMapping(new ChangeRankInformationCommand(true), "set");
        ranksCommand.addCommandMapping(new ChangeRankInformationCommand(false), "remove");
        CommandRouter playeroptionsCommand = new CommandRouter(this.plugin.getCommand(PLAYEROPTIONS_COMMAND));
        playeroptionsCommand.addCommandMapping(new PlayerOptionsCommand(this), new String[0]);
        this.updateRankInformation();
    }

    @Override
    protected void shutdownServer() {
        Bukkit.getServer().shutdown();
    }

    public UtilsPluginBukkit getPlugin() {
        return this.plugin;
    }

    public OfflinePlayer getCachedOfflinePlayer(String name) {
        OfflinePlayer p = this.playerUUIDCache != null ? this.playerUUIDCache.getPlayer(name) : this.plugin.getServer().getOfflinePlayerIfCached(name);
        return p == null || p.getName() == null ? null : p;
    }

    public OfflinePlayer getCachedOfflinePlayer(UUID uuid) {
        OfflinePlayer p = this.playerUUIDCache != null ? this.playerUUIDCache.getPlayer(uuid) : this.plugin.getServer().getOfflinePlayer(uuid);
        return p == null || p.getName() == null ? null : p;
    }

    public GlobalClientPlugin getGlobalClientPlugin() {
        return this.globalClientPlugin;
    }

    @Override
    protected ConnectionAPI getConnectionApi() {
        return this.globalClientPlugin.getConnectionAPI();
    }

    public UtilsDatabaseBukkit getDatabase() {
        return this.database;
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public PlayerDataCache getPlayerDataCache() {
        return this.playerDataCache;
    }

    @Override
    public UtilsGlobalDataHelperBukkit getGlobalDataHelper() {
        return this.globalDataHelper;
    }

    @Override
    public InventoryInputManagerImpl getInventoryInputManager() {
        return this.inventoryInputManager;
    }

    public PlayerReconfigurationPhaseHelper getReconfigurationPhaseHelper() {
        return this.reconfigurationPhaseHelper;
    }

    @Override
    public OnlinePlayerDataImpl getPlayerData(Player player) {
        return this.getPlayerData(player.getUniqueId()).getOnlineData();
    }

    @Override
    public PlayerDataImplBukkit getPlayerData(OfflinePlayer player) {
        return this.getPlayerData(player.getUniqueId());
    }

    @Override
    public PlayerDataImplBukkit getPlayerData(UUID playerId) {
        return (PlayerDataImplBukkit)this.playerDataCache.get(playerId);
    }

    @Override
    protected Iterable<? extends PlayerDataImpl> getLoadedPlayerData() {
        return this.playerDataCache.loadedData();
    }

    @Override
    public List<OfflinePlayer> searchPlayersByPartialName(String partialName) {
        try {
            return this.getDatabase().searchPlayersByPartialName(partialName);
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Exception while trying to query database.", e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getWorldDisplayName(LivingEntity entity) {
        return this.getWorldDisplayName(entity == null ? null : entity.getWorld());
    }

    @Override
    public String getWorldDisplayName(World world) {
        return this.getWorldDisplayName(world == null ? null : world.getName());
    }

    @Override
    public String getWorldDisplayName(String worldName) {
        return this.worldDisplayNames.getOrDefault(worldName, this.defaultDisplayName);
    }

    @Override
    public Set<String> getWorldDisplayNames(OfflinePlayer player) {
        return this.getWorldDisplayNames(player.getUniqueId());
    }

    @Override
    public Set<String> getWorldDisplayNames(UUID playerId) {
        HashSet<String> result = new HashSet<String>();
        GlobalPlayer gPlayer = this.globalDataHelper.getPlayer(playerId);
        for (GlobalServer server : this.globalDataHelper.getServers(gPlayer)) {
            String displayName = this.globalDataHelper.getPropertyValue(gPlayer, DISPLAY_NAME_PROPERTY_PREFIX + server.getName());
            if (displayName == null) continue;
            result.add(displayName);
        }
        return result;
    }

    @Override
    public void sendMessageToPlayersAllServers(Condition<? super Player> seeMsgCondition, String message) {
        ChatUtilBukkit.sendMessageToPlayers(seeMsgCondition, message);
        this.globalDataHelper.sendData(UtilsGlobalDataHelper.MessageType.SEND_MESSAGE, seeMsgCondition == null ? NullWrapper.INSTANCE : seeMsgCondition, (Object)false, (Object)message);
    }

    @Override
    public void sendMessageToPlayersAllServers(Condition<? super Player> seeMsgCondition, BaseComponent ... message) {
        ChatUtilBukkit.sendMessageToPlayers(seeMsgCondition, message);
        this.globalDataHelper.sendData(UtilsGlobalDataHelper.MessageType.SEND_MESSAGE, seeMsgCondition == null ? NullWrapper.INSTANCE : seeMsgCondition, (Object)true, (Object[])message);
    }

    @Override
    public void sendMessageToPlayersAllServers(Condition<? super Player> seeMsgCondition, Component message) {
        ChatUtilBukkit.sendMessageToPlayers(seeMsgCondition, message);
        this.globalDataHelper.sendData(UtilsGlobalDataHelper.MessageType.SEND_MESSAGE, seeMsgCondition == null ? NullWrapper.INSTANCE : seeMsgCondition, (Object)true, (Object)message);
    }

    @Override
    public void sendSoundSequenceToPlayersAllServers(Condition<? super Player> hearSoundCondition, SoundSequence soundSequence) {
        soundSequence.playToAll(hearSoundCondition, (Plugin)this.plugin);
        this.globalDataHelper.sendData(UtilsGlobalDataHelper.MessageType.SOUND_SEQUENCE, hearSoundCondition == null ? NullWrapper.INSTANCE : hearSoundCondition, (Object)soundSequence);
    }

    @Override
    public void sendPlayerOptions(CommandSender sender, OfflinePlayer player) {
        PlayerOptionsRetrievedEvent event = new PlayerOptionsRetrievedEvent(sender, player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        BaseComponent[] options = event.getOptions();
        if (options.length > 0) {
            PlayerDataImplBukkit playerData = this.getPlayerData(player);
            sender.sendMessage(new BaseComponent[]{new TextComponent("  "), new TextComponent(TextComponent.fromLegacyText((String)(playerData.getRankPrefix() + player.getName()))), new TextComponent(": "), new TextComponent(options)});
        }
    }

    @Override
    public void doAfterReconfigurationPhase(Player player, List<Consumer<? super Player>> actions) {
        this.reconfigurationPhaseHelper.doActions(player, actions);
    }

    @Override
    public void doAfterReconfigurationPhase(Player player, Consumer<? super Player> action) {
        this.reconfigurationPhaseHelper.doAction(player, action);
    }

    @Override
    public AnvilGUI createAnvilGUI(Player player) {
        return new AnvilGUI(this, player);
    }

    static {
        StringSerialization.register("GlobalLocation", GlobalLocationWrapper::deserialize);
        StringSerialization.register("HasPermissionCondition", HasPermissionCondition::deserialize);
        StringSerialization.register(HasCustomPlayerDataValueCondition.SERIALIZATION_TYPE, HasCustomPlayerDataValueCondition::deserialize);
        StringSerialization.register("SoundSequence", SoundSequence::deserialize);
        new SerializablePair<Object, Object>(null, null);
        new SerializableTriple<Object, Object, Object>(null, null, null);
        new SerializableComponent((BaseComponent)new TextComponent());
    }
}

