/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.adventure.translations;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.NotNull;

public final class ChainedTranslator
implements Translator {
    @NotNull
    private final Key name;
    @NotNull
    private final List<Translator> translators;

    public ChainedTranslator(@NotNull Key name, @NotNull List<Translator> translators) {
        this.name = name;
        this.translators = List.copyOf(translators);
    }

    public ChainedTranslator(@NotNull Key name, Translator ... translators) {
        this(name, Arrays.asList(translators));
    }

    @Override
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        for (Translator translator : this.translators) {
            MessageFormat result = translator.translate(key, locale);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @NotNull
    public Key name() {
        return this.name;
    }
}

