/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public interface Locatable {
    public Location getLocation();

    public static class EntityWrapper
    implements Locatable {
        private Entity entity;
        private double offsetX;
        private double offsetY;
        private double offsetZ;

        public EntityWrapper(Entity entity) {
            this(entity, 0.0, 0.0, 0.0);
        }

        public EntityWrapper(Entity entity, double offsetX, double offsetY, double offsetZ) {
            this.entity = Objects.requireNonNull(entity);
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }

        @Override
        public Location getLocation() {
            return this.entity.getLocation().add(this.offsetX, this.offsetY, this.offsetZ);
        }
    }

    public static class LocationWrapper
    implements Locatable {
        private Location location;

        public LocationWrapper(Location location) {
            this.location = Objects.requireNonNull(location);
        }

        @Override
        public Location getLocation() {
            return this.location;
        }
    }
}

