/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.linkextractor;

import de.iani.cubesideutils.linkextractor.LinkSegment;
import de.iani.cubesideutils.linkextractor.PlainSegment;
import de.iani.cubesideutils.linkextractor.Segment;
import java.util.ArrayList;
import java.util.List;

public class LinkExtractor {
    public static List<Segment> extractLinks(String s) {
        int dot;
        ArrayList<Segment> result = new ArrayList<Segment>();
        int pos = 0;
        int addedTo = 0;
        while ((dot = s.indexOf(46, pos)) >= 0) {
            int end;
            int start = LinkExtractor.searchBackwards(s, dot, pos);
            if (start >= 0 && (end = LinkExtractor.searchForward(s, dot)) >= 0) {
                if (start > pos) {
                    result.add(new PlainSegment(s.substring(addedTo, start)));
                }
                result.add(new LinkSegment(s.substring(start, end + 1)));
                addedTo = pos = end + 1;
                continue;
            }
            pos = dot + 1;
        }
        if (addedTo < s.length()) {
            result.add(new PlainSegment(s.substring(addedTo, s.length())));
        }
        return result;
    }

    private static int searchForward(String s, int dot) {
        String tld;
        char c;
        int len = s.length();
        if (dot + 2 >= len || !LinkExtractor.isAlphaNumAscii(s.charAt(dot + 1))) {
            return -1;
        }
        int lastSafePos = dot + 1;
        boolean lastWasDot = false;
        for (int pos = dot + 2; pos < len; ++pos) {
            c = s.charAt(pos);
            if (LinkExtractor.isAlphaNumAscii(c)) {
                lastSafePos = pos;
                lastWasDot = false;
                continue;
            }
            if (lastWasDot) break;
            if (c == '.') {
                if (lastSafePos < pos - 1) break;
                lastWasDot = true;
                continue;
            }
            if (!LinkExtractor.isAlphaNumDashAscii(c)) break;
            lastWasDot = false;
        }
        if ((tld = s.substring(s.lastIndexOf(46, lastSafePos) + 1, lastSafePos + 1)).length() < 2 || !LinkExtractor.isAlphabeticAscii(tld.charAt(0)) || !LinkExtractor.isAlphabeticAscii(tld.charAt(1))) {
            return -1;
        }
        if (lastSafePos + 1 < len && ((c = s.charAt(lastSafePos + 1)) == '/' || c == '?')) {
            int nextSpace = s.indexOf(32, lastSafePos + 1);
            if (nextSpace == -1) {
                return len - 1;
            }
            return nextSpace - 1;
        }
        return lastSafePos;
    }

    private static int searchBackwards(String s, int dot, int minPos) {
        if (minPos >= dot || !LinkExtractor.isAlphaNumAscii(s.charAt(dot - 1))) {
            return -1;
        }
        int lastSafePos = dot - 1;
        for (int pos = dot - 2; pos >= minPos; --pos) {
            char c = s.charAt(pos);
            if (LinkExtractor.isAlphaNumAscii(c)) {
                lastSafePos = pos;
                continue;
            }
            if (!LinkExtractor.isAlphaNumDashAscii(c)) break;
        }
        if (lastSafePos - 7 >= minPos && s.regionMatches(true, lastSafePos - 7, "http://", 0, 7)) {
            return lastSafePos - 7;
        }
        if (lastSafePos - 8 >= minPos && s.regionMatches(true, lastSafePos - 8, "https://", 0, 8)) {
            return lastSafePos - 8;
        }
        return lastSafePos;
    }

    private static boolean isAlphabeticAscii(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isDigitAscii(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphaNumAscii(char c) {
        return LinkExtractor.isAlphabeticAscii(c) || LinkExtractor.isDigitAscii(c);
    }

    private static boolean isAlphaNumDashAscii(char c) {
        return LinkExtractor.isAlphabeticAscii(c) || LinkExtractor.isDigitAscii(c) || c == '-';
    }
}

