/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.OnlinePlayerDataImpl;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class AfkManager
implements Listener {
    private static final int AFK_CHECK_BINS = 50;
    private CubesideUtilsBukkit core = CubesideUtilsBukkit.getInstance();
    private Set<Player>[] onlinePlayers;
    private int currentTick;
    public static final long AFK_THRESHOLD = 600000L;

    public AfkManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.core.getPlugin());
        this.onlinePlayers = new Set[50];
        for (int i = 0; i < 50; ++i) {
            this.onlinePlayers[i] = new LinkedHashSet<Player>();
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.core.getPlugin(), this::tick, 10L, 1L);
    }

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.onlinePlayers[Math.floorMod(event.getPlayer().getUniqueId().hashCode(), 50)].add(player);
        this.core.getPlayerData(player).checkAfk(false);
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        this.onlinePlayers[Math.floorMod(event.getPlayer().getUniqueId().hashCode(), 50)].remove(event.getPlayer());
    }

    private void tick() {
        for (Player player : this.onlinePlayers[this.currentTick % 50]) {
            OnlinePlayerDataImpl data = this.core.getPlayerData(player);
            data.checkAfk(true);
        }
        ++this.currentTick;
    }
}

