/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.collections;

import com.google.common.collect.Sets;
import de.iani.cubesideutils.collections.IteratorUtil;
import de.iani.cubesideutils.collections.SimpleCacheMap;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AdvancedCacheMap<K, V, D>
extends SimpleCacheMap<K, V> {
    private static final long serialVersionUID = -47074743727889121L;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<K, V> hardCache = new HashMap();
    private D defaultData;

    protected AdvancedCacheMap(int maxSoftCacheSize, D defaultData) {
        super(maxSoftCacheSize);
        this.defaultData = defaultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(K key) {
        this.writeLock().lock();
        try {
            boolean hardCached = false;
            V uncached = this.hardCache.remove(key);
            if (uncached == null) {
                uncached = super.remove(key);
            } else {
                hardCached = true;
            }
            if (uncached == null) {
                return;
            }
            boolean replace = this.shouldBeReplaced(key, uncached, hardCached);
            this.uncached(key, uncached, hardCached, replace);
            if (replace) {
                V replacement = this.getReplacement(key, uncached);
                if (replacement != null) {
                    this.hardCache.put(key, replacement);
                }
                this.replaced(key, uncached, replacement);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public V get(Object key) {
        return this.get(key, this.defaultData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V get(Object key, D data) {
        this.checkData(data);
        if (!this.checkKey(key)) {
            return null;
        }
        this.readLock().lock();
        try {
            block13: {
                V v;
                V result = this.hardCache.get(key);
                if (result != null) {
                    V v2 = result;
                    return v2;
                }
                result = super.get(key);
                if (result != null || !this.shouldLoadIntoCache(key, data)) {
                    V v3 = result;
                    return v3;
                }
                this.readLock().unlock();
                this.writeLock().lock();
                try {
                    this.readLock().lock();
                    result = this.hardCache.get(key);
                    if (result == null) break block13;
                    v = result;
                    this.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    this.writeLock().unlock();
                    throw throwable;
                }
                return v;
            }
            Object object = super.computeIfAbsent(key, k -> this.load(k, data));
            this.writeLock().unlock();
            return (V)object;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V result = this.get(key);
        return result == null ? defaultValue : result;
    }

    @Override
    public boolean containsKey(Object key) {
        this.readLock().lock();
        try {
            boolean bl = super.containsKey(key) || this.hardCache.containsKey(key);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public boolean containsValue(Object key) {
        this.readLock().lock();
        try {
            boolean bl = super.containsValue(key) || this.hardCache.containsValue(key);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Sets.union(super.entrySet(), this.hardCache.entrySet());
    }

    @Override
    public Set<K> keySet() {
        return Sets.union(super.keySet(), this.hardCache.keySet());
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return IteratorUtil.concat(AdvancedCacheMap.super.values(), AdvancedCacheMap.this.hardCache.values()).iterator();
            }

            @Override
            public int size() {
                return AdvancedCacheMap.this.size();
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.readLock().lock();
        try {
            this.entrySet().forEach((? super T entry) -> action.accept((Object)entry.getKey(), (Object)entry.getValue()));
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.readLock().lock();
        try {
            int n = super.size() + this.hardCache.size();
            return n;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    protected Lock readLock() {
        return this.lock.readLock();
    }

    protected Lock writeLock() {
        return this.lock.writeLock();
    }

    protected abstract void checkData(D var1);

    protected abstract boolean checkKey(Object var1);

    protected abstract boolean shouldLoadIntoCache(K var1, D var2);

    protected abstract V load(K var1, D var2);

    protected Map<K, V> getHardCache() {
        return this.hardCache;
    }

    protected V getFromHardCache(K key) {
        this.readLock().lock();
        try {
            V v = this.hardCache.get(key);
            return v;
        }
        finally {
            this.readLock().unlock();
        }
    }

    protected void addToHardCache(K key, V value) {
        this.writeLock().lock();
        try {
            this.invalidate(key);
            this.hardCache.put(key, value);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    protected V removeFromHardCache(K key) {
        this.writeLock().lock();
        try {
            V v = this.hardCache.remove(key);
            return v;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    protected V getFromSoftCache(K key) {
        this.readLock().lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            this.readLock().unlock();
        }
    }

    protected void addToSoftCache(K key, V value) {
        this.writeLock().lock();
        try {
            if (this.hardCache.containsKey(key)) {
                throw new IllegalArgumentException("cannot add mapping to soft cache that exists in hard cache");
            }
            super.put(key, value);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    protected V removeFromSoftCache(K key) {
        this.writeLock().lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    protected boolean shouldBeReplaced(K key, V uncached, boolean removedFromHardCache) {
        return removedFromHardCache;
    }

    protected void uncached(K key, V uncached, boolean removedFromHardCache, boolean willBeReplaced) {
    }

    protected abstract V getReplacement(K var1, V var2);

    protected void replaced(K key, V uncached, V replacement) {
    }
}

