/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.RandomUtil;
import de.iani.cubesideutils.plugin.CubesideUtils;
import de.iani.cubesideutils.plugin.api.PasswordHandler;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordHandlerImpl
implements PasswordHandler {
    public static final int SALT_LENGTH = 16;
    public static final int ITERATION_COUNT = 10000;
    public static final int HASH_LENGTH = 64;
    private static final SecretKeyFactory FACTORY;
    private String key;

    public PasswordHandlerImpl(String key) {
        if (key.length() > 64 || key.isEmpty()) {
            throw new IllegalArgumentException("key may neither be empty nor longer than 64");
        }
        this.key = key;
    }

    @Override
    public boolean test(UUID holderId, String password) throws SQLException {
        Pair<byte[], byte[]> entry = CubesideUtils.getInstance().getDatabase().getPasswordEntry(this.key, holderId);
        if (entry == null) {
            return false;
        }
        byte[] hash = this.hash(password, (byte[])entry.first);
        return Arrays.equals(hash, (byte[])entry.second);
    }

    @Override
    public void set(UUID holderId, String password) throws SQLException {
        byte[] salt = new byte[16];
        RandomUtil.SHARED_SECURE_RANDOM.nextBytes(salt);
        byte[] hash = this.hash(password, salt);
        CubesideUtils.getInstance().getDatabase().setPasswordHash(this.key, holderId, (byte[])salt.clone(), (byte[])hash.clone());
    }

    @Override
    public void remove(UUID holderId) throws SQLException {
        CubesideUtils.getInstance().getDatabase().removePassword(this.key, holderId);
    }

    private byte[] hash(String password, byte[] salt) {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 10000, 512);
        try {
            return FACTORY.generateSecret(spec).getEncoded();
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            FACTORY = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

