/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.TagType;
import java.util.Arrays;

public final class ByteArrayTag
implements BaseTag<ByteArrayTag> {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private byte[] data = EMPTY_ARRAY;

    public ByteArrayTag() {
    }

    public ByteArrayTag(byte[] data) {
        this.setData(data);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        this.data = data;
    }

    @Override
    public TagType getType() {
        return TagType.BYTE_ARRAY;
    }

    public String toString() {
        return "[" + this.data.length + " bytes]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArrayTag)) return false;
        ByteArrayTag other = (ByteArrayTag)obj;
        if (!Arrays.equals(this.data, other.data)) return false;
        return true;
    }

    @Override
    public ByteArrayTag clone() {
        try {
            ByteArrayTag clone = (ByteArrayTag)super.clone();
            clone.data = (byte[])this.data.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone should be supported");
        }
    }
}

