/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin.api;

import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.GlobalServer;
import de.cubeside.connection.PlayerMessageAPI;
import de.cubeside.connection.PlayerPropertiesAPI;
import de.cubeside.connection.event.GlobalDataEvent;
import de.cubeside.connection.util.GlobalLocation;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.serialization.GlobalLocationWrapper;
import de.iani.cubesideutils.plugin.GlobalDataHelperImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class GlobalDataHelperBukkit<T extends Enum<T>>
extends GlobalDataHelperImpl<T>
implements PlayerMessageAPI,
PlayerPropertiesAPI,
Listener {
    private final PlayerMessageAPI playerMsgApi;
    private final PlayerPropertiesAPI playerPropertiesApi;
    protected final JavaPlugin plugin;

    public GlobalDataHelperBukkit(Class<T> messageTypeClass, String channel, JavaPlugin plugin) {
        super(messageTypeClass, channel);
        this.plugin = plugin;
        GlobalClientPlugin globalClientPlugin = CubesideUtilsBukkit.getInstance().getGlobalClientPlugin();
        this.playerMsgApi = globalClientPlugin.getMessageAPI();
        this.playerPropertiesApi = globalClientPlugin.getPlayerPropertiesAPI();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public GlobalPlayer getPlayer(OfflinePlayer player) {
        return this.getPlayer(player.getUniqueId());
    }

    @Deprecated
    public void sendMessage(OfflinePlayer player, String message) {
        this.sendMessage(this.getPlayer(player), message);
    }

    @Deprecated
    public void sendMessage(UUID playerId, String message) {
        this.sendMessage(this.getPlayer(playerId), message);
    }

    @Deprecated
    public void sendMessage(String playerName, String message) {
        this.sendMessage(this.getPlayer(playerName), message);
    }

    @Deprecated
    public void sendMessage(GlobalPlayer player, String message) {
        this.playerMsgApi.sendMessage(player, message);
    }

    public void sendMessage(OfflinePlayer player, Component message) {
        this.sendMessage(this.getPlayer(player), message);
    }

    public void sendMessage(UUID playerId, Component message) {
        this.sendMessage(this.getPlayer(playerId), message);
    }

    public void sendMessage(String playerName, Component message) {
        this.sendMessage(this.getPlayer(playerName), message);
    }

    public void sendMessage(GlobalPlayer player, Component message) {
        this.playerMsgApi.sendMessage(player, message);
    }

    @Deprecated
    public void sendMessage(OfflinePlayer player, BaseComponent ... message) {
        this.sendMessage(this.getPlayer(player), message);
    }

    @Deprecated
    public void sendMessage(UUID playerId, BaseComponent ... message) {
        this.sendMessage(this.getPlayer(playerId), message);
    }

    @Deprecated
    public void sendMessage(String playerName, BaseComponent ... message) {
        this.sendMessage(this.getPlayer(playerName), message);
    }

    @Deprecated
    public void sendMessage(GlobalPlayer player, BaseComponent ... message) {
        this.playerMsgApi.sendMessage(player, message);
    }

    @Deprecated
    public void sendActionBarMessage(OfflinePlayer player, String message) {
        this.sendActionBarMessage(this.getPlayer(player), message);
    }

    @Deprecated
    public void sendActionBarMessage(UUID playerId, String message) {
        this.sendActionBarMessage(this.getPlayer(playerId), message);
    }

    @Deprecated
    public void sendActionBarMessage(String playerName, String message) {
        this.sendActionBarMessage(this.getPlayer(playerName), message);
    }

    @Deprecated
    public void sendActionBarMessage(GlobalPlayer player, String message) {
        this.playerMsgApi.sendActionBarMessage(player, message);
    }

    public void sendActionBarMessage(GlobalPlayer player, Component message) {
        this.playerMsgApi.sendActionBarMessage(player, message);
    }

    @Deprecated
    public void sendTitleBarMessage(OfflinePlayer player, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.sendTitleBarMessage(this.getPlayer(player), title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    @Deprecated
    public void sendTitleBarMessage(UUID playerId, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.sendTitleBarMessage(this.getPlayer(playerId), title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    @Deprecated
    public void sendTitleBarMessage(String playerName, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.sendTitleBarMessage(this.getPlayer(playerName), title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    @Deprecated
    public void sendTitleBarMessage(GlobalPlayer player, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.playerMsgApi.sendTitleBarMessage(player, title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    public void sendTitleBarMessage(GlobalPlayer player, Component title, Component subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.playerMsgApi.sendTitleBarMessage(player, title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    public boolean hasProperty(OfflinePlayer player, String property) {
        return this.hasProperty(this.getPlayer(player), property);
    }

    public boolean hasProperty(UUID playerId, String property) {
        return this.hasProperty(this.getPlayer(playerId), property);
    }

    public boolean hasProperty(String playerName, String property) {
        return this.hasProperty(this.getPlayer(playerName), property);
    }

    public boolean hasProperty(GlobalPlayer player, String property) {
        return this.playerPropertiesApi.hasProperty(player, property);
    }

    public String getPropertyValue(OfflinePlayer player, String property) {
        return this.getPropertyValue(this.getPlayer(player), property);
    }

    public String getPropertyValue(UUID playerId, String property) {
        return this.getPropertyValue(this.getPlayer(playerId), property);
    }

    public String getPropertyValue(String playerName, String property) {
        return this.getPropertyValue(this.getPlayer(playerName), property);
    }

    public String getPropertyValue(GlobalPlayer player, String property) {
        return this.playerPropertiesApi.getPropertyValue(player, property);
    }

    public Map<String, String> getAllProperties(OfflinePlayer player) {
        return this.getAllProperties(this.getPlayer(player));
    }

    public Map<String, String> getAllProperties(UUID playerId) {
        return this.getAllProperties(this.getPlayer(playerId));
    }

    public Map<String, String> getAllProperties(String playerName) {
        return this.getAllProperties(this.getPlayer(playerName));
    }

    public Map<String, String> getAllProperties(GlobalPlayer player) {
        return this.playerPropertiesApi.getAllProperties(player);
    }

    public void setPropertyValue(OfflinePlayer player, String property, String value) {
        this.setPropertyValue(this.getPlayer(player), property, value);
    }

    public void setPropertyValue(UUID playerId, String property, String value) {
        this.setPropertyValue(this.getPlayer(playerId), property, value);
    }

    public void setPropertyValue(String playerName, String property, String value) {
        this.setPropertyValue(this.getPlayer(playerName), property, value);
    }

    public void setPropertyValue(GlobalPlayer player, String property, String value) {
        this.playerPropertiesApi.setPropertyValue(player, property, value);
    }

    public List<GlobalServer> getServers(OfflinePlayer player) {
        return this.getServers(player, false);
    }

    public List<GlobalServer> getServers(OfflinePlayer player, boolean includeNonReals) {
        return this.getServers(this.getPlayer(player), includeNonReals);
    }

    public boolean isOnAnyServer(OfflinePlayer player) {
        return this.isOnAnyServer(player, false);
    }

    public boolean isOnAnyServer(OfflinePlayer player, boolean includeNonReals) {
        return this.isOnAnyServer(this.getPlayer(player), includeNonReals);
    }

    @Override
    protected void sendMsgPart(DataOutputStream msgout, Object msg) throws IOException {
        if (msg instanceof GlobalLocation) {
            GlobalLocationWrapper wrapper = new GlobalLocationWrapper((GlobalLocation)msg);
            this.sendMsgPart(msgout, wrapper);
        } else {
            super.sendMsgPart(msgout, msg);
        }
    }

    protected GlobalLocation readGlobalLocation(DataInputStream msgin) throws IOException {
        GlobalLocationWrapper wrapper = (GlobalLocationWrapper)GlobalDataHelperBukkit.readStringSerializable(msgin);
        return wrapper.original;
    }

    protected Component readAdventureComponent(DataInputStream msgin) throws IOException {
        String serialized = msgin.readUTF();
        return JSONComponentSerializer.json().deserialize((Object)serialized);
    }

    @EventHandler
    public void onGlobalDataEvent(GlobalDataEvent event) throws IOException {
        if (!event.getChannel().equals(this.getChannel())) {
            return;
        }
        DataInputStream data = new DataInputStream(event.getData());
        int messageTypeId = data.readInt();
        Object messageType = this.fromOrdinal(messageTypeId);
        if (messageType == null) {
            this.plugin.getLogger().log(Level.WARNING, "Unknown data type for DataHelper " + this.getMessageTypeClass().getName() + ": " + messageTypeId);
        } else {
            this.handleMessage(messageType, event.getSource(), data);
        }
    }
}

