/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.velocity.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.plugin.CubesideUtils;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import de.iani.cubesideutils.velocity.plugin.CubesideUtilsVelocity;
import de.iani.cubesideutils.velocity.plugin.PlayerDataImplVelocity;
import de.iani.cubesideutils.velocity.plugin.api.GlobalDataHelperVelocity;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;

public class UtilsGlobalDataHelperVelocity
extends GlobalDataHelperVelocity<UtilsGlobalDataHelper.MessageType>
implements UtilsGlobalDataHelper {
    private Map<UtilsGlobalDataHelper.MessageType, Set<BiConsumer<GlobalServer, DataInputStream>>> handlers = new EnumMap<UtilsGlobalDataHelper.MessageType, Set<BiConsumer<GlobalServer, DataInputStream>>>(UtilsGlobalDataHelper.MessageType.class);

    public UtilsGlobalDataHelperVelocity(CubesideUtilsVelocity plugin) {
        super(UtilsGlobalDataHelper.MessageType.class, "UtilsPlugin", plugin);
    }

    @Override
    public void registerHandler(UtilsGlobalDataHelper.MessageType type, BiConsumer<GlobalServer, DataInputStream> consumer) {
        this.handlers.computeIfAbsent(type, t -> new LinkedHashSet()).add((source, data) -> {
            try {
                consumer.accept((GlobalServer)source, (DataInputStream)data);
            }
            catch (Exception | StackOverflowError e) {
                CubesideUtils.getInstance().getLogger().log(Level.SEVERE, "Exception trying to call handler for MessageType " + String.valueOf((Object)type), e);
            }
        });
    }

    @Override
    protected void handleMessage(UtilsGlobalDataHelper.MessageType messageType, GlobalServer source, DataInputStream data) throws IOException {
        switch (messageType) {
            case RANK_INFORMATION_CHANGED: {
                CubesideUtilsVelocity.getInstance().updateRankInformation();
                break;
            }
            case GENERAL_DATA_CHANGED: {
                CubesideUtilsVelocity.getInstance().getGeneralDataCache().invalidate(data.readUTF());
                break;
            }
            case PLAYER_DATA_CHANGED: {
                CubesideUtilsVelocity.getInstance().getPlayerDataCache().invalidate(UtilsGlobalDataHelperVelocity.readUUID(data));
                break;
            }
            case CUSTOM_PLAYER_DATA_CHANGED: {
                PlayerDataImplVelocity pData = CubesideUtilsVelocity.getInstance().getPlayerDataCache().get(UtilsGlobalDataHelperVelocity.readUUID(data), false, false);
                if (pData == null) break;
                pData.customDataChanged();
                break;
            }
            case SEND_MESSAGE: {
                break;
            }
        }
    }
}

