/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.items;

import de.iani.cubesideutils.bukkit.items.ItemGroups;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;

public class RepairationMaterials {
    private static final Map<Material, Material> repairationMaterialsInternal = new HashMap<Material, Material>();
    public static final Map<Material, Material> REPAIRATION_MATERIALS = Collections.unmodifiableMap(repairationMaterialsInternal);
    public static final Set<Material> REPAIRABLE_MATERIALS = Collections.unmodifiableSet(repairationMaterialsInternal.keySet());

    private RepairationMaterials() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static boolean isRepairable(Material material) {
        return REPAIRABLE_MATERIALS.contains(material);
    }

    public static Material getRepairationMaterial(Material material) {
        return REPAIRATION_MATERIALS.get(material);
    }

    public static boolean isRepairableBy(Material material, Material by) {
        if (!RepairationMaterials.isRepairable(material)) {
            return false;
        }
        if (material == by) {
            return true;
        }
        Material repairation = RepairationMaterials.getRepairationMaterial(material);
        if (repairation == by) {
            return true;
        }
        if (repairation == Material.OAK_PLANKS) {
            return ItemGroups.isPlanks(by);
        }
        return false;
    }

    static {
        String[] toolSuffixes = new String[]{"AXE", "HOE", "PICKAXE", "SHOVEL", "SWORD"};
        String[] armorSuffixes = new String[]{"HELMET", "CHESTPLATE", "LEGGINGS", "BOOTS"};
        for (String string : toolSuffixes) {
            repairationMaterialsInternal.put(Material.valueOf((String)("WOODEN_" + string)), Material.OAK_PLANKS);
            repairationMaterialsInternal.put(Material.valueOf((String)("STONE_" + string)), Material.COBBLESTONE);
            repairationMaterialsInternal.put(Material.valueOf((String)("GOLDEN_" + string)), Material.GOLD_INGOT);
            repairationMaterialsInternal.put(Material.valueOf((String)("IRON_" + string)), Material.IRON_INGOT);
            repairationMaterialsInternal.put(Material.valueOf((String)("DIAMOND_" + string)), Material.DIAMOND);
            repairationMaterialsInternal.put(Material.valueOf((String)("NETHERITE_" + string)), Material.NETHERITE_INGOT);
        }
        for (String string : armorSuffixes) {
            repairationMaterialsInternal.put(Material.valueOf((String)("LEATHER_" + string)), Material.LEATHER);
            repairationMaterialsInternal.put(Material.valueOf((String)("GOLDEN_" + string)), Material.GOLD_INGOT);
            repairationMaterialsInternal.put(Material.valueOf((String)("CHAINMAIL_" + string)), Material.IRON_INGOT);
            repairationMaterialsInternal.put(Material.valueOf((String)("IRON_" + string)), Material.IRON_INGOT);
            repairationMaterialsInternal.put(Material.valueOf((String)("DIAMOND_" + string)), Material.DIAMOND);
            repairationMaterialsInternal.put(Material.valueOf((String)("NETHERITE_" + string)), Material.NETHERITE_INGOT);
        }
        repairationMaterialsInternal.put(Material.ELYTRA, Material.PHANTOM_MEMBRANE);
        for (String string : Material.values()) {
            if (string.isLegacy() || repairationMaterialsInternal.containsKey(string) || string.getMaxDurability() <= 0) continue;
            repairationMaterialsInternal.put((Material)string, (Material)string);
        }
    }
}

