/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class HtmlUtilBukkit {
    public static final String COLOR_BLACK_HEX = "#000000";

    public static String colorToHex(int rgb) {
        String color = Integer.toHexString(rgb & 0xFFFFFF);
        return COLOR_BLACK_HEX.substring(0, 7 - color.length()) + color;
    }

    public static String escapeHtml(String text) {
        StringBuilder sb = new StringBuilder();
        HtmlUtilBukkit.escapeHtml(sb, text);
        return sb.toString();
    }

    public static void escapeHtml(StringBuilder out, String text) {
        int len = text.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    public static String toHTML(String message) {
        return HtmlUtilBukkit.toHTML(new Component[]{LegacyComponentSerializer.legacySection().deserialize(message)});
    }

    public static String toHTML(Component ... message) {
        StringBuilder stringBuilder = new StringBuilder();
        HtmlUtilBukkit.toHTML(stringBuilder, TextDecoration.State.FALSE, TextDecoration.State.FALSE, Arrays.asList(message));
        return stringBuilder.toString();
    }

    private static void toHTML(StringBuilder stringBuilder, TextDecoration.State parentStrikethrough, TextDecoration.State parentUnderlined, List<Component> message) {
        for (Component component : message) {
            if (component instanceof TextComponent) {
                boolean anyFormat;
                TextComponent textComponent = (TextComponent)component;
                TextColor color = component.style().color();
                Integer colorRGB = color == null ? null : Integer.valueOf(color.red() << 16 | color.green() << 8 | color.blue());
                TextDecoration.State bold = component.style().decoration(TextDecoration.BOLD);
                TextDecoration.State italic = component.style().decoration(TextDecoration.ITALIC);
                TextDecoration.State strikethrough = component.style().decoration(TextDecoration.STRIKETHROUGH);
                TextDecoration.State underlined = component.style().decoration(TextDecoration.UNDERLINED);
                boolean bl = anyFormat = colorRGB != null || bold != TextDecoration.State.NOT_SET || italic != TextDecoration.State.NOT_SET || strikethrough != TextDecoration.State.NOT_SET || underlined != TextDecoration.State.NOT_SET;
                if (anyFormat) {
                    stringBuilder.append("<span style='");
                    if (colorRGB != null) {
                        stringBuilder.append("color:").append(HtmlUtilBukkit.colorToHex(colorRGB)).append(";");
                    }
                    if (bold != TextDecoration.State.NOT_SET) {
                        stringBuilder.append("font-weight:").append(bold == TextDecoration.State.TRUE ? "bold" : "normal").append(";");
                    }
                    if (italic != TextDecoration.State.NOT_SET) {
                        stringBuilder.append("font-style:").append(italic == TextDecoration.State.TRUE ? "italic" : "normal").append(";");
                    }
                    if (strikethrough != TextDecoration.State.NOT_SET || underlined != TextDecoration.State.NOT_SET) {
                        if (strikethrough == TextDecoration.State.NOT_SET) {
                            strikethrough = parentStrikethrough;
                        }
                        if (underlined == TextDecoration.State.NOT_SET) {
                            underlined = parentUnderlined;
                        }
                        stringBuilder.append("text-decoration:");
                        if (strikethrough == TextDecoration.State.TRUE) {
                            stringBuilder.append("line-through");
                        }
                        if (underlined == TextDecoration.State.TRUE) {
                            if (strikethrough == TextDecoration.State.TRUE) {
                                stringBuilder.append(" ");
                            }
                            stringBuilder.append("underline");
                        } else if (strikethrough == TextDecoration.State.FALSE) {
                            stringBuilder.append("none");
                        }
                        stringBuilder.append(";");
                    }
                    stringBuilder.append("'>");
                }
                HtmlUtilBukkit.escapeHtml(stringBuilder, textComponent.content());
                if (!textComponent.children().isEmpty()) {
                    HtmlUtilBukkit.toHTML(stringBuilder, strikethrough != null ? strikethrough : parentStrikethrough, underlined != null ? underlined : parentUnderlined, textComponent.children());
                }
                if (!anyFormat) continue;
                stringBuilder.append("</span>");
                continue;
            }
            HtmlUtilBukkit.toHTML(stringBuilder, parentStrikethrough, parentUnderlined, List.of(LegacyComponentSerializer.legacySection().deserialize(LegacyComponentSerializer.legacySection().serialize(component))));
        }
    }
}

