/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.events;

import com.google.common.base.Preconditions;
import de.iani.cubesideutils.bukkit.commands.CommandActionFlag;
import de.iani.cubesideutils.bukkit.commands.CommandUtil;
import de.iani.cubesideutils.commands.ArgsParser;
import java.util.Arrays;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;

public class CommandActionFlagsCheckEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final String commandLine;
    private String[] commandArgs;
    private final EnumMap<CommandActionFlag, TriState> actionFlags;
    @Nullable
    private final Command command;
    @Nullable
    private final Plugin plugin;

    public CommandActionFlagsCheckEvent(@Nonnull String commandLine) {
        this.commandLine = commandLine;
        this.command = CommandUtil.getCommandFromCommandLine(commandLine);
        this.plugin = this.command == null ? null : CommandUtil.getOwningPlugin(this.command);
        this.actionFlags = new EnumMap(CommandActionFlag.class);
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public void setActionFlag(@Nonnull CommandActionFlag flag, @Nonnull TriState state) {
        Preconditions.checkNotNull((Object)((Object)flag), (Object)"flag");
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.actionFlags.put(flag, state);
    }

    public void setActionFlag(@Nonnull CommandActionFlag flag, boolean state) {
        Preconditions.checkNotNull((Object)((Object)flag), (Object)"flag");
        this.actionFlags.put(flag, TriState.byBoolean((boolean)state));
    }

    @Nonnull
    public TriState getActionFlag(@Nonnull CommandActionFlag flag) {
        Preconditions.checkNotNull((Object)((Object)flag), (Object)"flag");
        return this.actionFlags.getOrDefault((Object)flag, TriState.NOT_SET);
    }

    public boolean getActionFlagUnknownToTrue(@Nonnull CommandActionFlag flag) {
        Preconditions.checkNotNull((Object)((Object)flag), (Object)"flag");
        return this.actionFlags.getOrDefault((Object)flag, TriState.NOT_SET).toBooleanOrElse(true);
    }

    @Nonnull
    public String getCommandLine() {
        return this.commandLine;
    }

    @Nullable
    public Command getCommand() {
        return this.command;
    }

    @Nullable
    public Plugin getOwningPlugin() {
        return this.plugin;
    }

    @Nonnull
    public ArgsParser getCommandArguments() {
        if (this.commandArgs == null) {
            String[] splitLine = StringUtils.split((String)this.commandLine, (char)' ');
            this.commandArgs = splitLine.length > 1 ? Arrays.copyOfRange(splitLine, 1, splitLine.length) : new String[]{};
        }
        return new ArgsParser(this.commandArgs);
    }
}

