/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bungee;

import de.iani.cubesideutils.ChatUtil;
import de.iani.cubesideutils.ChatUtilAdventure;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class ChatUtilsBungee {
    private ChatUtilsBungee() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static List<ChatUtilAdventure.Sendable<CommandSender>> stringToSendableList(List<String> messages) {
        ArrayList<ChatUtilAdventure.Sendable<CommandSender>> result = new ArrayList<ChatUtilAdventure.Sendable<CommandSender>>(messages.size());
        for (String msg : messages) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<ChatUtilAdventure.Sendable<CommandSender>> bcToSendableList(List<BaseComponent> messages) {
        ArrayList<ChatUtilAdventure.Sendable<CommandSender>> result = new ArrayList<ChatUtilAdventure.Sendable<CommandSender>>(messages.size());
        for (BaseComponent msg : messages) {
            result.add(new ComponentMsg(msg));
        }
        return result;
    }

    private static List<ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver>> convertSendableList(final List<? extends BungeeSendable> messages) {
        return new AbstractList<ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver>>(){

            @Override
            public ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver> get(int index) {
                return ((BungeeSendable)messages.get(index)).toGenericSendable();
            }

            @Override
            public int size() {
                return messages.size();
            }
        };
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BungeeSendable> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtilsBungee.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BungeeSendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtilsBungee.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BungeeSendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(new CommandSenderWrapper(recipient), ChatUtilsBungee.convertSendableList(messages), page, name, openPageCommandPrefix, pluginPrefix, normalColor, warningColor);
    }

    public static class StringMsg
    implements BungeeSendable {
        public final String message;

        public StringMsg(String message) {
            this.message = message;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.message);
        }

        @Override
        public ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver> toGenericSendable() {
            return new ChatUtilAdventure.StringMsg(this.message);
        }
    }

    public static class ComponentMsg
    implements BungeeSendable {
        public final BaseComponent message;

        public ComponentMsg(BaseComponent message) {
            this.message = message;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.message);
        }

        @Override
        public ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver> toGenericSendable() {
            return new ChatUtilAdventure.AdventureComponentMsg(ChatUtil.convertBaseComponent(this.message));
        }
    }

    public static class CommandSenderWrapper
    implements ChatUtil.MessageReceiver {
        private final CommandSender original;

        public CommandSenderWrapper(CommandSender original) {
            this.original = original;
        }

        @Override
        public void sendMessage(String message) {
            this.original.sendMessage(message);
        }

        @Override
        public void sendMessage(BaseComponent ... message) {
            this.original.sendMessage(message);
        }

        @Override
        public void sendMessage(Component message) {
            this.sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.gson().serialize(message))));
        }
    }

    public static interface BungeeSendable
    extends ChatUtilAdventure.Sendable<CommandSender> {
        public ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver> toGenericSendable();
    }
}

