/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.bukkit.ChatUtilBukkit;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.PlayerDataImplBukkit;
import de.iani.cubesideutils.bukkit.plugin.UtilsPluginBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.GlobalDataHelperBukkit;
import de.iani.cubesideutils.bukkit.sound.SoundSequence;
import de.iani.cubesideutils.conditions.Condition;
import de.iani.cubesideutils.plugin.CubesideUtils;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UtilsGlobalDataHelperBukkit
extends GlobalDataHelperBukkit<UtilsGlobalDataHelper.MessageType>
implements UtilsGlobalDataHelper {
    private Map<UtilsGlobalDataHelper.MessageType, Set<BiConsumer<GlobalServer, DataInputStream>>> handlers = new EnumMap<UtilsGlobalDataHelper.MessageType, Set<BiConsumer<GlobalServer, DataInputStream>>>(UtilsGlobalDataHelper.MessageType.class);

    public UtilsGlobalDataHelperBukkit(UtilsPluginBukkit plugin) {
        super(UtilsGlobalDataHelper.MessageType.class, "UtilsPlugin", plugin);
    }

    public void registerHandler(UtilsGlobalDataHelper.MessageType type, BiConsumer<GlobalServer, DataInputStream> consumer) {
        this.handlers.computeIfAbsent(type, t -> new LinkedHashSet()).add((source, data) -> {
            try {
                consumer.accept((GlobalServer)source, (DataInputStream)data);
            }
            catch (Exception | StackOverflowError e) {
                CubesideUtils.getInstance().getLogger().log(Level.SEVERE, "Exception trying to call handler for MessageType " + String.valueOf(type), e);
            }
        });
    }

    protected void handleMessage(UtilsGlobalDataHelper.MessageType messageType, GlobalServer source, DataInputStream data) throws IOException {
        this.handlers.getOrDefault(messageType, Set.of()).forEach(handler -> handler.accept(source, data));
        switch (messageType) {
            case RANK_INFORMATION_CHANGED: {
                CubesideUtilsBukkit.getInstance().updateRankInformation();
                break;
            }
            case GENERAL_DATA_CHANGED: {
                CubesideUtilsBukkit.getInstance().getGeneralDataCache().invalidate(data.readUTF());
                break;
            }
            case PLAYER_DATA_CHANGED: {
                CubesideUtilsBukkit.getInstance().getPlayerDataCache().invalidate(UtilsGlobalDataHelperBukkit.readUUID((DataInputStream)data));
                break;
            }
            case CUSTOM_PLAYER_DATA_CHANGED: {
                PlayerDataImplBukkit pData = CubesideUtilsBukkit.getInstance().getPlayerDataCache().get(UtilsGlobalDataHelperBukkit.readUUID((DataInputStream)data), false, false);
                if (pData == null) break;
                pData.customDataChanged();
                break;
            }
            case SEND_MESSAGE: {
                Condition seeMsgCondition = (Condition)UtilsGlobalDataHelperBukkit.readStringSerializable((DataInputStream)data);
                boolean componentMsg = data.readBoolean();
                if (componentMsg) {
                    Component message = this.readAdventureComponent(data);
                    ChatUtilBukkit.sendMessageToPlayers((Condition<? super Player>)seeMsgCondition, message);
                    break;
                }
                String message = data.readUTF();
                ChatUtilBukkit.sendMessageToPlayers((Condition<? super Player>)seeMsgCondition, message);
                break;
            }
            case SOUND_SEQUENCE: {
                Condition hearSoundCondition = (Condition)UtilsGlobalDataHelperBukkit.readStringSerializable((DataInputStream)data);
                SoundSequence sequence = (SoundSequence)UtilsGlobalDataHelperBukkit.readStringSerializable((DataInputStream)data);
                sequence.playToAll((Condition<? super Player>)hearSoundCondition, (Plugin)this.plugin);
                break;
            }
        }
    }
}

