/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.sound;

import com.google.common.base.Preconditions;
import de.iani.cubesideutils.conditions.Condition;
import de.iani.cubesideutils.serialization.StringSerializable;
import java.util.ArrayList;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SoundSequence
implements StringSerializable {
    public static final String SERIALIZATION_TYPE = "SoundSequence";
    private static final SoundSequence EMPTY = new SoundSequence(new SoundEvent[0]);
    private final SoundEvent[] soundEvents;
    private boolean hasDelay;

    private SoundSequence(SoundEvent ... soundEvents) {
        this.soundEvents = soundEvents;
        boolean hasDelay = false;
        for (int i = 0; !hasDelay && i < soundEvents.length; ++i) {
            if (!(soundEvents[i] instanceof SoundWaitEvent)) continue;
            hasDelay = true;
        }
        this.hasDelay = hasDelay;
    }

    public void play(Player player, Plugin plugin) {
        if (!this.hasDelay) {
            for (int i = 0; i < this.soundEvents.length; ++i) {
                SoundEvent soundEvent = this.soundEvents[i];
                if (!(soundEvent instanceof SoundPlayEvent)) continue;
                SoundPlayEvent playEvent = (SoundPlayEvent)soundEvent;
                playEvent.play(player);
            }
            return;
        }
        new SoundPlayer(player, plugin).play();
    }

    public void playToAll(Condition<? super Player> hearSoundCondition, Plugin plugin) {
        for (Player player : plugin.getServer().getOnlinePlayers()) {
            if (hearSoundCondition != null && !hearSoundCondition.test((Object)player)) continue;
            this.play(player, plugin);
        }
    }

    public void playToAll(Plugin plugin) {
        this.playToAll(null, plugin);
    }

    public static SoundSequence empty() {
        return EMPTY;
    }

    public static SoundSequence ofSingleSound(Sound.Type sound, Sound.Source source, float volume, float pitch) {
        Preconditions.checkNotNull((Object)sound, (Object)"sound");
        Preconditions.checkNotNull((Object)source, (Object)"source");
        return SoundSequence.ofSingleSound((Sound)Sound.sound().type(sound).volume(volume).pitch(pitch).source(source).build());
    }

    public static SoundSequence ofSingleSound(Key sound, Sound.Source source, float volume, float pitch) {
        Preconditions.checkNotNull((Object)sound, (Object)"sound");
        Preconditions.checkNotNull((Object)source, (Object)"source");
        return SoundSequence.ofSingleSound((Sound)Sound.sound().type(sound).volume(volume).pitch(pitch).source(source).build());
    }

    public static SoundSequence ofSingleSound(Sound sound) {
        Preconditions.checkNotNull((Object)sound, (Object)"sound");
        return new SoundSequence(new SoundPlayEvent(sound));
    }

    public String getSerializationType() {
        return SERIALIZATION_TYPE;
    }

    public String serializeToString() {
        StringBuilder sb = new StringBuilder();
        for (SoundEvent e : this.soundEvents) {
            if (!sb.isEmpty()) {
                sb.append(";");
            }
            if (e instanceof SoundPlayEvent) {
                SoundPlayEvent event = (SoundPlayEvent)e;
                Sound sound = event.sound;
                sb.append("p;").append(sound.name().asMinimalString());
                sb.append(";").append(sound.volume());
                sb.append(";").append(sound.pitch());
                if (sound.seed().isPresent()) {
                    sb.append(";").append(sound.seed().getAsLong());
                } else {
                    sb.append(";null");
                }
                sb.append(";").append(sound.source().name());
                continue;
            }
            if (!(e instanceof SoundWaitEvent)) continue;
            SoundWaitEvent event = (SoundWaitEvent)e;
            sb.append("w;").append(event.ticks);
        }
        return sb.toString();
    }

    public static SoundSequence deserialize(String serialized) {
        Builder soundSequence = new Builder();
        String[] parts = serialized.split("\\;");
        int pos = 0;
        while (pos < parts.length) {
            String type;
            if ((type = parts[pos++]).equals("p")) {
                Sound.Builder builder = Sound.sound();
                builder.type(Key.key((String)parts[pos++]));
                builder.volume(Float.parseFloat(parts[pos++]));
                builder.pitch(Float.parseFloat(parts[pos++]));
                String seed = parts[pos++];
                if (!seed.equals("null")) {
                    builder.seed(Long.parseLong(seed));
                }
                builder.source(Sound.Source.valueOf((String)parts[pos++]));
                soundSequence.play((Sound)builder.build());
                continue;
            }
            if (type.equals("w")) {
                int ticks = Integer.parseInt(parts[pos++]);
                soundSequence.delay(ticks);
                continue;
            }
            throw new IllegalArgumentException("type=" + type);
        }
        return soundSequence.build();
    }

    private static interface SoundEvent {
    }

    private static class SoundWaitEvent
    implements SoundEvent {
        private final int ticks;

        public SoundWaitEvent(int ticks) {
            this.ticks = ticks;
        }
    }

    private static class SoundPlayEvent
    implements SoundEvent {
        private final Sound sound;

        public SoundPlayEvent(Sound sound) {
            this.sound = sound;
        }

        public void play(Player player) {
            player.playSound(this.sound);
        }
    }

    private class SoundPlayer {
        private final Player player;
        private final Plugin plugin;
        private int nextSound;

        public SoundPlayer(Player player, Plugin plugin) {
            this.player = player;
            this.plugin = plugin;
        }

        public void play() {
            do {
                SoundEvent current;
                if ((current = SoundSequence.this.soundEvents[this.nextSound]) instanceof SoundPlayEvent) {
                    SoundPlayEvent event = (SoundPlayEvent)current;
                    event.play(this.player);
                    ++this.nextSound;
                    continue;
                }
                if (current instanceof SoundWaitEvent) {
                    SoundWaitEvent event = (SoundWaitEvent)current;
                    ++this.nextSound;
                    if (this.nextSound >= SoundSequence.this.soundEvents.length) {
                        return;
                    }
                    this.plugin.getServer().getScheduler().runTaskLater(this.plugin, this::play, (long)event.ticks);
                    return;
                }
                throw new IllegalStateException();
            } while (this.nextSound < SoundSequence.this.soundEvents.length);
        }
    }

    public static class Builder {
        private ArrayList<SoundEvent> soundEvents = new ArrayList();

        public Builder play(Sound.Type sound, Sound.Source source, float volume, float pitch) {
            Preconditions.checkNotNull((Object)sound, (Object)"sound");
            Preconditions.checkNotNull((Object)source, (Object)"source");
            return this.play((Sound)Sound.sound().type(sound).volume(volume).pitch(pitch).source(source).build());
        }

        public Builder play(Key sound, Sound.Source source, float volume, float pitch) {
            Preconditions.checkNotNull((Object)sound, (Object)"sound");
            Preconditions.checkNotNull((Object)source, (Object)"source");
            return this.play((Sound)Sound.sound().type(sound).volume(volume).pitch(pitch).source(source).build());
        }

        public Builder play(Sound sound) {
            Preconditions.checkNotNull((Object)sound, (Object)"sound");
            this.soundEvents.add(new SoundPlayEvent(sound));
            return this;
        }

        public Builder delay(int ticks) {
            Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks may not me negative");
            if (ticks > 0) {
                SoundEvent soundEvent;
                if (!this.soundEvents.isEmpty() && (soundEvent = this.soundEvents.get(this.soundEvents.size() - 1)) instanceof SoundWaitEvent) {
                    SoundWaitEvent waitEvent = (SoundWaitEvent)soundEvent;
                    int newTicks = ticks + waitEvent.ticks;
                    if (newTicks > 0) {
                        this.soundEvents.set(this.soundEvents.size() - 1, new SoundWaitEvent(newTicks));
                        return this;
                    }
                }
                this.soundEvents.add(new SoundWaitEvent(ticks));
            }
            return this;
        }

        public SoundSequence build() {
            if (this.soundEvents.isEmpty()) {
                return EMPTY;
            }
            return new SoundSequence(this.soundEvents.toArray(new SoundEvent[this.soundEvents.size()]));
        }
    }
}

