/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.cubeside.connection.GlobalPlayer;
import de.iani.cubesideutils.ChatUtil;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.conditions.Condition;
import de.iani.cubesideutils.plugin.CubesideUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatUtilBukkit
extends ChatUtil {
    private ChatUtilBukkit() {
    }

    public static List<BukkitSendable> stringToBukkitSendableList(List<String> messages) {
        ArrayList<BukkitSendable> result = new ArrayList<BukkitSendable>(messages.size());
        for (String msg : messages) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<BukkitSendable> bcToBukkitSendableList(List<BaseComponent[]> messages) {
        ArrayList<BukkitSendable> result = new ArrayList<BukkitSendable>(messages.size());
        for (BaseComponent[] msg : messages) {
            result.add(new ComponentMsg(msg));
        }
        return result;
    }

    private static List<ChatUtil.Sendable<ChatUtil.MessageReceiver>> convertSendableList(final List<? extends BukkitSendable> messages) {
        return new AbstractList<ChatUtil.Sendable<ChatUtil.MessageReceiver>>(){

            @Override
            public ChatUtil.Sendable<ChatUtil.MessageReceiver> get(int index) {
                return ((BukkitSendable)messages.get(index)).toGenericSendable();
            }

            @Override
            public int size() {
                return messages.size();
            }
        };
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, (Component)Component.text((String)name), openPageCommandPrefix);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, Component name, String openPageCommandPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, null);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, Component name, String openPageCommandPrefix, Component pluginPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, Style.style((TextColor)NamedTextColor.GREEN), Style.style((TextColor)NamedTextColor.GOLD));
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, Component name, String openPageCommandPrefix, Component pluginPrefix, Style normalStyle, Style warningStyle) {
        ChatUtil.sendMessagesPaged(new CommandSenderWrapper(recipient), ChatUtilBukkit.convertSendableList(messages), page, name, openPageCommandPrefix, pluginPrefix, normalStyle, warningStyle);
    }

    @Deprecated
    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, net.md_5.bungee.api.ChatColor.GREEN, net.md_5.bungee.api.ChatColor.GOLD);
    }

    @Deprecated
    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, net.md_5.bungee.api.ChatColor normalColor, net.md_5.bungee.api.ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(new CommandSenderWrapper(recipient), ChatUtilBukkit.convertSendableList(messages), page, name, openPageCommandPrefix, pluginPrefix, normalColor, warningColor);
    }

    @Deprecated
    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent name, String openPageCommandPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    @Deprecated
    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, net.md_5.bungee.api.ChatColor.GREEN, net.md_5.bungee.api.ChatColor.GOLD);
    }

    @Deprecated
    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent name, String openPageCommandPrefix, String pluginPrefix, net.md_5.bungee.api.ChatColor normalColor, net.md_5.bungee.api.ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(new CommandSenderWrapper(recipient), ChatUtilBukkit.convertSendableList(messages), page, new BaseComponent[]{name}, openPageCommandPrefix, pluginPrefix, normalColor, warningColor);
    }

    @Deprecated
    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent[] name, String openPageCommandPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    @Deprecated
    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, net.md_5.bungee.api.ChatColor.GREEN, net.md_5.bungee.api.ChatColor.GOLD);
    }

    @Deprecated
    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix, net.md_5.bungee.api.ChatColor normalColor, net.md_5.bungee.api.ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(new CommandSenderWrapper(recipient), ChatUtilBukkit.convertSendableList(messages), page, name, openPageCommandPrefix, pluginPrefix, normalColor, warningColor);
    }

    public static void sendMessageToPlayers(Condition<? super Player> seeMsgCondition, String message) {
        ChatUtilBukkit.sendMessageToPlayers(seeMsgCondition, new StringMsg(message));
    }

    @Deprecated
    public static void sendMessageToPlayers(Condition<? super Player> seeMsgCondition, BaseComponent ... message) {
        ChatUtilBukkit.sendMessageToPlayers(seeMsgCondition, new ComponentMsg(message));
    }

    public static void sendMessageToPlayers(Condition<? super Player> seeMsgCondition, Component message) {
        ChatUtilBukkit.sendMessageToPlayers(seeMsgCondition, new AdventureComponentMsg(message));
    }

    public static void sendMessageToPlayers(Condition<? super Player> seeMsgCondition, BukkitSendable message) {
        message.send(Bukkit.getConsoleSender());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (seeMsgCondition != null && !seeMsgCondition.test((Player)player)) continue;
            message.send(player);
        }
    }

    public static void sendMessage(CommandSender receiver, Component pluginPrefix, Style style, Object ... messageParts) {
        ChatUtil.sendMessage((ChatUtil.MessageReceiver)new CommandSenderWrapper(receiver), pluginPrefix, style, messageParts);
    }

    public static void sendMessage(UUID playerId, Component pluginPrefix, Style style, Object ... messageParts) {
        ChatUtil.sendMessage((ChatUtil.MessageReceiver)new GlobalPlayerWrapper(playerId), pluginPrefix, style, messageParts);
    }

    @Deprecated
    public static void sendMessage(CommandSender receiver, String pluginPrefix, String colors, Object ... messageParts) {
        ChatUtil.sendMessage((ChatUtil.MessageReceiver)new CommandSenderWrapper(receiver), pluginPrefix, colors, messageParts);
    }

    @Deprecated
    public static void sendMessage(UUID playerId, String pluginPrefix, String colors, Object ... messageParts) {
        ChatUtil.sendMessage((ChatUtil.MessageReceiver)new GlobalPlayerWrapper(playerId), pluginPrefix, colors, messageParts);
    }

    @Deprecated
    public static Integer toRGB(ChatColor color) {
        return ChatUtil.toRGB(color.asBungee());
    }

    public static class StringMsg
    implements BukkitSendable {
        public final String message;

        public StringMsg(String message) {
            this.message = message;
        }

        @Override
        public void send(CommandSender recipient) {
            new CommandSenderWrapper(recipient).sendMessage(this.message);
        }

        @Override
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable() {
            return new ChatUtil.StringMsg(this.message);
        }
    }

    @Deprecated
    public static class ComponentMsg
    implements BukkitSendable {
        public final BaseComponent[] message;

        public ComponentMsg(BaseComponent[] message) {
            this.message = message;
        }

        public ComponentMsg(BaseComponent message) {
            this.message = new BaseComponent[]{message};
        }

        @Override
        public void send(CommandSender recipient) {
            new CommandSenderWrapper(recipient).sendMessage(this.message);
        }

        @Override
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable() {
            return new ChatUtil.BaseComponentMsg(this.message);
        }
    }

    public static class CommandSenderWrapper
    implements ChatUtil.MessageReceiver {
        private final CommandSender original;

        public CommandSenderWrapper(CommandSender original) {
            this.original = original;
        }

        @Override
        public void sendMessage(String message) {
            this.original.sendMessage(message);
        }

        @Override
        @Deprecated
        public void sendMessage(BaseComponent ... message) {
            try {
                this.original.sendMessage(message);
            }
            catch (NoSuchMethodError e) {
                this.original.sendMessage(BaseComponent.toLegacyText((BaseComponent[])message));
            }
        }

        @Override
        public void sendMessage(Component message) {
            this.original.sendMessage(message);
        }
    }

    public static interface BukkitSendable
    extends ChatUtil.Sendable<CommandSender> {
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable();
    }

    public static class AdventureComponentMsg
    implements BukkitSendable {
        public final Component message;

        public AdventureComponentMsg(Component message) {
            this.message = message;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.message);
        }

        @Override
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable() {
            return new ChatUtil.AdventureComponentMsg(this.message);
        }
    }

    public static class GlobalPlayerWrapper
    implements ChatUtil.MessageReceiver {
        private GlobalPlayer gPlayer;

        public GlobalPlayerWrapper(GlobalPlayer gPlayer) {
            this.gPlayer = Objects.requireNonNull(gPlayer);
        }

        public GlobalPlayerWrapper(UUID playerId) {
            this.gPlayer = CubesideUtils.getInstance().getGlobalDataHelper().getPlayer(playerId);
            if (this.gPlayer == null) {
                throw new IllegalArgumentException("player not found");
            }
        }

        @Override
        @Deprecated
        public void sendMessage(String message) {
            CubesideUtilsBukkit.getInstance().getGlobalDataHelper().sendMessage(this.gPlayer, message);
        }

        @Override
        public void sendMessage(Component message) {
            CubesideUtilsBukkit.getInstance().getGlobalDataHelper().sendMessage(this.gPlayer, message);
        }
    }
}

