/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.iani.cubesideutils.StringUtil;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffects {
    private static final Map<PotionEffectType, Integer> typeToMax = new HashMap<PotionEffectType, Integer>();

    private PotionEffects() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    private static void addEffectType(PotionEffectType type, int maxAmplifier) {
        typeToMax.put(type, maxAmplifier - 1);
    }

    public static int getMaxAmplifier(PotionEffectType type) {
        int res = typeToMax.getOrDefault(type, -1);
        if (res == -1) {
            CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "No maximum level known for PotionEffectType " + String.valueOf(type));
            res = 0;
        }
        return res;
    }

    @Deprecated
    public static String toNiceString(PotionEffect effect) {
        Object result = StringUtil.capitalizeFirstLetter((String)effect.getType().getName(), (boolean)true);
        if (effect.getAmplifier() != 0 || PotionEffects.getMaxAmplifier(effect.getType()) != 0) {
            result = (String)result + " " + StringUtil.toRomanNumber((int)(effect.getAmplifier() + 1));
        }
        if (effect.isAmbient() || !effect.hasParticles() || !effect.hasIcon()) {
            result = (String)result + " (";
            boolean first = true;
            if (effect.isAmbient()) {
                if (!first) {
                    result = (String)result + ", ";
                }
                first = false;
                result = (String)result + "ambient";
            }
            if (!effect.hasParticles()) {
                if (!first) {
                    result = (String)result + ", ";
                }
                first = false;
                result = (String)result + "no particles";
            }
            if (!effect.hasIcon()) {
                if (!first) {
                    result = (String)result + ", ";
                }
                first = false;
                result = (String)result + "no icon";
            }
            result = (String)result + ")";
        }
        if (!effect.getType().isInstant()) {
            result = (String)result + " for " + (effect.getDuration() == 0 ? "0 s" : StringUtil.formatTimespan((long)(effect.getDuration() * 50), (String)"d", (String)"h", (String)"m", (String)"s", (String)" ", (String)" "));
        }
        return result;
    }

    static {
        PotionEffects.addEffectType(PotionEffectType.ABSORPTION, 4);
        PotionEffects.addEffectType(PotionEffectType.BAD_OMEN, 5);
        PotionEffects.addEffectType(PotionEffectType.BLINDNESS, 1);
        PotionEffects.addEffectType(PotionEffectType.CONDUIT_POWER, 1);
        PotionEffects.addEffectType(PotionEffectType.NAUSEA, 1);
        PotionEffects.addEffectType(PotionEffectType.RESISTANCE, 2);
        PotionEffects.addEffectType(PotionEffectType.DARKNESS, 1);
        PotionEffects.addEffectType(PotionEffectType.DOLPHINS_GRACE, 1);
        PotionEffects.addEffectType(PotionEffectType.HASTE, 2);
        PotionEffects.addEffectType(PotionEffectType.FIRE_RESISTANCE, 1);
        PotionEffects.addEffectType(PotionEffectType.GLOWING, 1);
        PotionEffects.addEffectType(PotionEffectType.INSTANT_DAMAGE, 2);
        PotionEffects.addEffectType(PotionEffectType.INSTANT_HEALTH, 2);
        PotionEffects.addEffectType(PotionEffectType.HEALTH_BOOST, 0);
        PotionEffects.addEffectType(PotionEffectType.HERO_OF_THE_VILLAGE, 5);
        PotionEffects.addEffectType(PotionEffectType.HUNGER, 1);
        PotionEffects.addEffectType(PotionEffectType.STRENGTH, 2);
        PotionEffects.addEffectType(PotionEffectType.INVISIBILITY, 1);
        PotionEffects.addEffectType(PotionEffectType.JUMP_BOOST, 2);
        PotionEffects.addEffectType(PotionEffectType.LEVITATION, 1);
        PotionEffects.addEffectType(PotionEffectType.LUCK, 0);
        PotionEffects.addEffectType(PotionEffectType.NIGHT_VISION, 1);
        PotionEffects.addEffectType(PotionEffectType.POISON, 2);
        PotionEffects.addEffectType(PotionEffectType.REGENERATION, 2);
        PotionEffects.addEffectType(PotionEffectType.SATURATION, 0);
        PotionEffects.addEffectType(PotionEffectType.SLOWNESS, 4);
        PotionEffects.addEffectType(PotionEffectType.MINING_FATIGUE, 3);
        PotionEffects.addEffectType(PotionEffectType.SLOW_FALLING, 1);
        PotionEffects.addEffectType(PotionEffectType.SPEED, 2);
        PotionEffects.addEffectType(PotionEffectType.UNLUCK, 0);
        PotionEffects.addEffectType(PotionEffectType.WATER_BREATHING, 1);
        PotionEffects.addEffectType(PotionEffectType.WEAKNESS, 2);
        PotionEffects.addEffectType(PotionEffectType.WITHER, 2);
    }
}

