/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.bukkit.plugin.AnvilGUI;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.PlayerDataImplBukkit;
import de.iani.cubesideutils.bukkit.plugin.UtilsGlobalDataHelperBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.OnlinePlayerData;
import de.iani.cubesideutils.bukkit.plugin.api.events.GlobalAfkStateChangeEvent;
import de.iani.cubesideutils.bukkit.plugin.api.events.LocalAfkStateChangeEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class OnlinePlayerDataImpl
extends PlayerDataImplBukkit
implements OnlinePlayerData {
    private long lastLocalAction;
    private boolean manuallySetAfk;
    private boolean locallyAfk;
    private String hostName;
    private AnvilGUI openAnvilGUI;

    public OnlinePlayerDataImpl(UUID playerId, long firstJoin, long lastJoin, long lastSeen, boolean afk, long lastAction, boolean manuallySetAfk, String lastName, String rank) {
        super(playerId, firstJoin, lastJoin, lastSeen, afk, lastName, rank);
        this.lastLocalAction = lastAction;
        this.manuallySetAfk = manuallySetAfk;
        this.locallyAfk = afk;
    }

    protected void postConstruction() {
    }

    public synchronized void quit() {
        this.setLocallyAfk(false, false);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> ((OnlinePlayerDataImpl)this).notifyChanges());
    }

    @Override
    public Player getPlayer() {
        Player result = Bukkit.getPlayer((UUID)this.getPlayerId());
        if (!(result != null || (result = CubesideUtilsBukkit.getInstance().getPlayerDataCache().getCurrentlyLoggingInPlayer()) != null && result.getUniqueId().equals(this.getPlayerId()))) {
            return null;
        }
        return result;
    }

    @Override
    public synchronized long getLastAction() {
        return this.lastLocalAction;
    }

    public synchronized void madeAction() {
        this.lastLocalAction = System.currentTimeMillis();
        this.manuallySetAfk = false;
        this.checkAfk(true);
    }

    public synchronized void checkAfk(boolean messagePlayer) {
        boolean afk;
        boolean bl = afk = System.currentTimeMillis() >= this.lastLocalAction + 600000L;
        if (afk == this.isLocallyAfk() || !afk && this.manuallySetAfk) {
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            this.setLocallyAfk(afk, messagePlayer);
        } else {
            Bukkit.getScheduler().runTask((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> this.setLocallyAfk(afk, messagePlayer));
        }
    }

    @Override
    public synchronized boolean isLocallyAfk() {
        return this.locallyAfk;
    }

    @Override
    public synchronized boolean isManuallySetAfk() {
        return this.manuallySetAfk;
    }

    @Override
    public synchronized void manuallySetAfk(boolean messagePlayer) {
        this.manuallySetAfk = true;
        this.setLocallyAfk(true, messagePlayer);
    }

    public synchronized void setLocallyAfk(boolean afk, boolean messagePlayer) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("May only be invoked on the bukkit primary thread.");
        }
        if (this.locallyAfk == afk) {
            return;
        }
        LocalAfkStateChangeEvent event = new LocalAfkStateChangeEvent(this, afk);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.locallyAfk = afk;
        if (!afk) {
            this.manuallySetAfk = false;
        }
        try {
            CubesideUtilsBukkit.getInstance().getDatabase().setLocallyAfk(this.getPlayerId(), afk);
        }
        catch (SQLException e) {
            CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "Could not save AFK-status in database.", e);
        }
        this.checkGloballyAfk();
        if (messagePlayer) {
            this.getPlayer().sendMessage(String.valueOf(ChatColor.GRAY) + "* Du bist nun" + (this.locallyAfk ? "" : " nicht mehr") + " abwesend.");
        }
    }

    private void checkGloballyAfk() {
        Set afkServers;
        if (this.locallyAfk && this.isGloballyAfk()) {
            return;
        }
        if (!this.locallyAfk && !this.isGloballyAfk()) {
            return;
        }
        if (!this.locallyAfk) {
            this.setGloballyAfkInternal(false);
            return;
        }
        UtilsGlobalDataHelperBukkit globalHelper = CubesideUtilsBukkit.getInstance().getGlobalDataHelper();
        List servers = globalHelper.getServers(this.getPlayerId());
        assert (servers.contains(globalHelper.getThisServer()));
        if (servers.size() == 1) {
            this.setGloballyAfkInternal(true);
            return;
        }
        try {
            afkServers = CubesideUtilsBukkit.getInstance().getDatabase().getAfkServers(this.getPlayerId());
        }
        catch (SQLException e) {
            CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "Could not load AFK-status from database.", e);
            return;
        }
        for (GlobalServer server : servers) {
            if (afkServers.contains(server.getName())) continue;
            return;
        }
        this.setGloballyAfkInternal(true);
    }

    private void setGloballyAfkInternal(boolean afk) {
        if (afk == this.isGloballyAfk()) {
            return;
        }
        GlobalAfkStateChangeEvent event = new GlobalAfkStateChangeEvent(this, afk);
        if (Bukkit.isPrimaryThread()) {
            Bukkit.getPluginManager().callEvent((Event)event);
        } else {
            try {
                Bukkit.getScheduler().callSyncMethod((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> event.callEvent()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        this.setGloballyAfk(afk);
        try {
            CubesideUtilsBukkit.getInstance().getDatabase().setGloballyAfk(this.getPlayerId(), afk);
        }
        catch (SQLException e) {
            CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "Exception trying to save afk value for player " + String.valueOf(this.getPlayerId()) + " in database.", e);
            return;
        }
        this.notifyChanges();
    }

    @Override
    public void checkRank() {
        this.checkRank((Permissible)this.getPlayer());
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    public void setOpenAnvilGUI(AnvilGUI anvilGUI) {
        this.openAnvilGUI = anvilGUI;
    }

    @Override
    public AnvilGUI getOpenAnvilGUI() {
        return this.openAnvilGUI;
    }
}

