/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.items;

import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private final ItemStack item;
    private final ItemMeta meta;

    private ItemBuilder(ItemStack item) {
        this.item = item.clone();
        this.meta = this.item.getItemMeta();
    }

    public static ItemBuilder fromItem(ItemStack item) {
        return new ItemBuilder(item);
    }

    public static ItemBuilder fromMaterial(Material material) {
        return ItemBuilder.fromItem(new ItemStack(material));
    }

    public ItemBuilder displayName(String displayName) {
        this.meta.setDisplayName(displayName);
        return this;
    }

    public ItemBuilder displayName(Component displayName) {
        this.meta.displayName(displayName);
        return this;
    }

    public ItemBuilder lore(String ... lore) {
        this.meta.setLore(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder lore(Component ... lore) {
        this.meta.lore(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder enchantment(Enchantment enchantment, int level) {
        return this.enchantment(enchantment, level, true);
    }

    public ItemBuilder enchantment(Enchantment enchantment, int level, boolean ignoreMaxLevel) {
        this.meta.addEnchant(enchantment, level, ignoreMaxLevel);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.meta.removeEnchant(enchantment);
        return this;
    }

    public ItemBuilder flag(ItemFlag flag) {
        this.meta.addItemFlags(new ItemFlag[]{flag});
        return this;
    }

    public ItemBuilder removeFlag(ItemFlag flag) {
        this.meta.removeItemFlags(new ItemFlag[]{flag});
        return this;
    }

    public ItemBuilder hideTooltip(boolean hide) {
        this.meta.setHideTooltip(hide);
        return this;
    }

    public ItemBuilder clean() {
        this.item.removeItemFlags(this.item.getItemFlags().toArray(new ItemFlag[0]));
        this.item.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)this.item).removeEnchantment(arg_0));
        this.meta.lore(null);
        this.meta.displayName(null);
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

