/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.plugin.GlobalDataHelperImpl;
import de.iani.cubesideutils.plugin.api.GlobalDataRequestManager;
import de.iani.cubesideutils.serialization.StringSerializable;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class GlobalDataRequestManagerImpl<T extends Enum<T>>
implements GlobalDataRequestManager<T> {
    private static final long TIMEOUT_MS = 60000L;
    private static final Timer timeoutTimer = new Timer();
    private GlobalDataHelperImpl<T> helper;
    private Map<UUID, Request<?>> activeRequests;

    public GlobalDataRequestManagerImpl(Pair<GlobalDataHelperImpl<T>, Delegator<T>> helperAndDelegator) {
        this.helper = (GlobalDataHelperImpl)helperAndDelegator.first;
        this.activeRequests = Collections.synchronizedMap(new HashMap());
        ((Delegator)helperAndDelegator.second).setRequestManager(this);
    }

    protected GlobalDataHelperImpl<T> getHelper() {
        return this.helper;
    }

    @Override
    public <V> Future<V> makeRequest(T requestType, GlobalServer server, Object ... data) {
        UUID requestId = UUID.randomUUID();
        Request request = new Request(requestId);
        this.activeRequests.put(requestId, request);
        Object[] requestData = new Object[data.length + 2];
        requestData[0] = false;
        requestData[1] = requestId;
        System.arraycopy(data, 0, requestData, 2, data.length);
        this.getHelper().sendData(server, requestType, requestData);
        return request;
    }

    protected void handleMessage(T messageType, GlobalServer source, DataInputStream data) throws IOException {
        ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
        DataOutputStream responseOut = new DataOutputStream(responseBytes);
        boolean isResponse = data.readBoolean();
        UUID requestId = this.readUUID(data);
        if (isResponse) {
            Request<?> request = this.activeRequests.remove(requestId);
            if (request == null) {
                throw new NoSuchElementException("unknown request id");
            }
            if (!request.setResponseReceived()) {
                return;
            }
            try {
                request.set(this.handleResponse(messageType, source, data));
            }
            catch (Throwable t) {
                request.error(t);
            }
        } else {
            responseOut.writeInt(((Enum)messageType).ordinal());
            responseOut.writeBoolean(true);
            this.sendMsgPart(responseOut, requestId);
            this.respondToRequest(messageType, source, data, responseOut);
            byte[] msgarry = responseBytes.toByteArray();
            source.sendData(this.getHelper().getChannel(), msgarry);
        }
    }

    protected void sendMsgPart(DataOutputStream msgout, Object msg) throws IOException {
        this.getHelper().sendMsgPart(msgout, msg);
    }

    protected void sendMsgParts(DataOutputStream msgout, Object ... msgs) throws IOException {
        for (Object msg : msgs) {
            this.sendMsgPart(msgout, msg);
        }
    }

    protected UUID readUUID(DataInputStream msgin) throws IOException {
        return this.getHelper().readUUID(msgin);
    }

    protected <S extends StringSerializable> S readStringSerializable(DataInputStream msgin) throws IOException {
        return this.getHelper().readStringSerializable(msgin);
    }

    protected abstract void respondToRequest(T var1, GlobalServer var2, DataInputStream var3, DataOutputStream var4) throws IOException;

    protected abstract Object handleResponse(T var1, GlobalServer var2, DataInputStream var3) throws IOException;

    protected static class Delegator<T extends Enum<T>> {
        private GlobalDataRequestManagerImpl<T> requestManager;

        public void handleMessage(T messageType, GlobalServer source, DataInputStream data) throws IOException {
            if (this.requestManager == null) {
                throw new IllegalStateException();
            }
            this.requestManager.handleMessage(messageType, source, data);
        }

        private void setRequestManager(GlobalDataRequestManagerImpl<T> requestManager) {
            if (this.requestManager != null) {
                throw new IllegalStateException();
            }
            this.requestManager = Objects.requireNonNull(requestManager);
        }
    }

    private class Request<V>
    implements Future<V> {
        private final Object lock = new Object();
        private boolean cancelled;
        private boolean responseReceived;
        private boolean done;
        private Throwable thrown;
        private V result;
        private TimerTask timeoutTask;
        private UUID requestId;

        private Request(UUID requestId) {
            this.requestId = requestId;
            this.timeoutTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = Request.this.lock;
                    synchronized (object) {
                        if (Request.this.responseReceived || Request.this.cancelled) {
                            return;
                        }
                        GlobalDataRequestManagerImpl.this.activeRequests.remove(Request.this.requestId, Request.this);
                        Request.this.responseReceived = true;
                        Request.this.done = true;
                        Request.this.thrown = new TimeoutException();
                        Request.this.lock.notifyAll();
                    }
                }
            };
            timeoutTimer.schedule(this.timeoutTask, 60000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!mayInterruptIfRunning) {
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.responseReceived) {
                    return false;
                }
                this.cancelled = true;
                this.done = true;
                this.timeoutTask.cancel();
                this.lock.notifyAll();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object object = this.lock;
            synchronized (object) {
                return this.cancelled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object object = this.lock;
            synchronized (object) {
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, ExecutionException {
            Object object = this.lock;
            synchronized (object) {
                while (!this.done) {
                    this.lock.wait();
                }
                if (this.cancelled) {
                    throw new CancellationException();
                }
                return this.getResult();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long start = System.currentTimeMillis();
            Object object = this.lock;
            synchronized (object) {
                while (timeout > 0L && !this.done) {
                    this.lock.wait(unit.toMillis(timeout));
                    long now = System.currentTimeMillis();
                    timeout = now - start;
                    start = now;
                }
                if (this.cancelled) {
                    throw new CancellationException();
                }
                if (!this.done) {
                    throw new TimeoutException();
                }
                return this.getResult();
            }
        }

        private V getResult() throws ExecutionException {
            if (this.thrown != null) {
                throw new ExecutionException(this.thrown);
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(V result) {
            Object object = this.lock;
            synchronized (object) {
                if (this.done || !this.responseReceived) {
                    throw new IllegalStateException();
                }
                this.result = result;
                this.done = true;
                this.timeoutTask.cancel();
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void error(Throwable thrown) {
            Object object = this.lock;
            synchronized (object) {
                if (this.done || !this.responseReceived) {
                    throw new IllegalStateException();
                }
                this.thrown = thrown;
                this.done = true;
                this.timeoutTask.cancel();
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setResponseReceived() {
            Object object = this.lock;
            synchronized (object) {
                if (this.cancelled) {
                    return false;
                }
                this.responseReceived = true;
                return true;
            }
        }
    }
}

