/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.StringUtil;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.SelectorComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;

public class ComponentUtil {
    private static final Map<ChatColor, String> CONSTANT_CHAT_COLORS;

    private ComponentUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static final boolean isColor(ChatColor color) {
        return color != ChatColor.BOLD && color != ChatColor.ITALIC && color != ChatColor.MAGIC && color != ChatColor.RESET && color != ChatColor.STRIKETHROUGH && color != ChatColor.UNDERLINE;
    }

    public static BaseComponent deserializeComponent(String text) throws ParseException {
        return ComponentUtil.convertEscaped(text);
    }

    public static BaseComponent deserializeComponent(String text, int from, int to) throws ParseException {
        return ComponentUtil.convertEscaped(text, from, to);
    }

    public static BaseComponent convertEscaped(String text) throws ParseException {
        return ComponentUtil.convertEscaped(text, 0, text.length());
    }

    public static BaseComponent convertEscaped(String text, int from, int to) throws ParseException {
        return new EscapedConverter(text, from, to).convert();
    }

    public static String serializeComponent(BaseComponent component) {
        return ComponentUtil.serializeComponent(component, new StringBuilder()).toString();
    }

    private static StringBuilder serializeComponent(BaseComponent component, StringBuilder builder) {
        ComponentUtil.serializeColor(component, builder);
        ComponentUtil.serializeFormatting(component, builder);
        ComponentUtil.serializeEvents(component, builder);
        if (component instanceof TextComponent) {
            ComponentUtil.serializeTextComponent((TextComponent)component, builder);
        } else if (component instanceof TranslatableComponent) {
            ComponentUtil.serializeTranslatableComponent((TranslatableComponent)component, builder);
        } else if (component instanceof ScoreComponent) {
            ComponentUtil.serializeScoreComponent((ScoreComponent)component, builder);
        } else if (component instanceof SelectorComponent) {
            ComponentUtil.serializeSelectorComponent((SelectorComponent)component, builder);
        } else if (component instanceof KeybindComponent) {
            ComponentUtil.serializeKeybindComponent((KeybindComponent)component, builder);
        } else {
            throw new IllegalArgumentException("unsupported component type " + component.getClass().getName());
        }
        ComponentUtil.serializeExtraComponents(component, builder);
        return builder;
    }

    private static void escapeString(String raw, StringBuilder builder) {
        block4: for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            switch (c) {
                case '\n': {
                    builder.append("\\n");
                    continue block4;
                }
                case '&': 
                case '\\': 
                case '{': 
                case '}': {
                    builder.append('\\');
                }
                default: {
                    builder.append(c);
                }
            }
        }
    }

    private static void serializeColor(BaseComponent component, StringBuilder builder) {
        ChatColor color = component.getColorRaw();
        if (color == null) {
            return;
        }
        String colorString = CONSTANT_CHAT_COLORS.get(color);
        if (colorString != null) {
            builder.append(colorString);
            return;
        }
        builder.append("&x");
        ComponentUtil.appendHexColorString(color.getColor(), builder);
    }

    private static void appendHexColorString(Color color, StringBuilder builder) {
        String hexString = Integer.toHexString(color.getRGB());
        int i = 0;
        while (i + hexString.length() < 6) {
            builder.append('0');
            ++i;
        }
        builder.append(hexString);
    }

    private static void serializeFormatting(BaseComponent component, StringBuilder builder) {
        if (component.isObfuscatedRaw() == Boolean.TRUE) {
            builder.append("&k");
        }
        if (component.isBoldRaw() == Boolean.TRUE) {
            builder.append("&l");
        }
        if (component.isStrikethroughRaw() == Boolean.TRUE) {
            builder.append("&m");
        }
        if (component.isUnderlinedRaw() == Boolean.TRUE) {
            builder.append("&n");
        }
        if (component.isItalicRaw() == Boolean.TRUE) {
            builder.append("&o");
        }
        if (component.getFontRaw() != null) {
            builder.append("\\f{").append(component.getFontRaw()).append('}');
        }
    }

    private static void serializeEvents(BaseComponent component, StringBuilder builder) {
        String insertion;
        ClickEvent ce;
        HoverEvent he = component.getHoverEvent();
        if (he != null) {
            builder.append("\\h");
            List hoverContents = he.getContents();
            if (hoverContents.size() != 1) {
                throw new IllegalArgumentException("HoverEvents with more than one content object are not supported.");
            }
            switch (he.getAction()) {
                case SHOW_TEXT: {
                    builder.append("t{");
                    Text text = (Text)hoverContents.get(0);
                    if (text.getValue() instanceof String) {
                        ComponentUtil.escapeString((String)text.getValue(), builder);
                    } else if (text.getValue() instanceof BaseComponent[]) {
                        ComponentUtil.serializeComponent((BaseComponent)new TextComponent((BaseComponent[])text.getValue()));
                    } else {
                        throw new ClassCastException("Expected HoverEvent Text value to be instance of String or BaseComponent[].");
                    }
                    builder.append('}');
                    break;
                }
                case SHOW_ITEM: {
                    builder.append("i{");
                    Item item = (Item)hoverContents.get(0);
                    builder.append(item.getId()).append(',').append(item.getCount()).append(',');
                    ComponentUtil.escapeString(item.getTag().getNbt(), builder);
                    builder.append('}');
                    break;
                }
                case SHOW_ENTITY: {
                    builder.append("e{");
                    Entity entity = (Entity)hoverContents.get(0);
                    builder.append(entity.getType()).append(',').append(entity.getId()).append(',');
                    ComponentUtil.serializeComponent(entity.getName(), builder);
                    builder.append('}');
                    break;
                }
                default: {
                    throw new IllegalArgumentException("HoverEvent Action " + he.getAction() + " is not supported.");
                }
            }
        }
        if ((ce = component.getClickEvent()) != null) {
            builder.append("\\c");
            switch (ce.getAction()) {
                case RUN_COMMAND: {
                    builder.append('r');
                    break;
                }
                case SUGGEST_COMMAND: {
                    builder.append('s');
                    break;
                }
                case COPY_TO_CLIPBOARD: {
                    builder.append('c');
                    break;
                }
                case CHANGE_PAGE: {
                    builder.append('p');
                    break;
                }
                case OPEN_URL: {
                    builder.append('u');
                    break;
                }
                case OPEN_FILE: {
                    throw new IllegalArgumentException("ClickEvent Action OPEN_FILE is rejectet by clients and not supported.");
                }
            }
            builder.append('{');
            ComponentUtil.escapeString(ce.getValue(), builder);
            builder.append('}');
        }
        if ((insertion = component.getInsertion()) != null) {
            builder.append("\\i{");
            ComponentUtil.escapeString(insertion, builder);
            builder.append('}');
        }
    }

    private static void serializeExtraComponents(BaseComponent component, StringBuilder builder) {
        ArrayList<BaseComponent> extra = component.getExtra();
        if (extra == null) {
            return;
        }
        extra = new ArrayList<BaseComponent>(extra);
        extra.removeIf(bc -> bc.toPlainText().isEmpty());
        if (extra.isEmpty()) {
            return;
        }
        for (BaseComponent bc2 : extra) {
            if (extra.size() != 1) {
                builder.append('{');
            }
            ComponentUtil.serializeComponent(bc2, builder);
            if (extra.size() == 1) continue;
            builder.append('}');
        }
    }

    private static void serializeTextComponent(TextComponent componet, StringBuilder builder) {
        ComponentUtil.escapeString(componet.getText(), builder);
    }

    private static void serializeTranslatableComponent(TranslatableComponent component, StringBuilder builder) {
        builder.append("\\t{");
        builder.append(component.getTranslate());
        for (BaseComponent with : component.getWith()) {
            builder.append('{');
            ComponentUtil.serializeComponent(with, builder);
            builder.append('}');
        }
        builder.append('}');
    }

    private static void serializeScoreComponent(ScoreComponent component, StringBuilder builder) {
        builder.append("\\s{");
        builder.append(component.getName()).append(',');
        builder.append(component.getObjective()).append(',');
        builder.append(component.getValue());
        builder.append('}');
    }

    private static void serializeSelectorComponent(SelectorComponent component, StringBuilder builder) {
        builder.append("\\@{");
        builder.append(component.getSelector());
        builder.append('}');
    }

    private static void serializeKeybindComponent(KeybindComponent component, StringBuilder builder) {
        builder.append("\\k{");
        builder.append(component.getKeybind());
        builder.append('}');
    }

    public static <T extends BaseComponent> T setColor(T component, ChatColor color) {
        component.setColor(color);
        return component;
    }

    public static TextComponent setColor(String text, ChatColor color) {
        TextComponent component = new TextComponent(text);
        component.setColor(color);
        return component;
    }

    public static <T extends BaseComponent> T setBold(T component, Boolean bold) {
        component.setBold(bold);
        return component;
    }

    public static <T extends BaseComponent> T setItalic(T component, Boolean italic) {
        component.setItalic(italic);
        return component;
    }

    public static <T extends BaseComponent> T setStrikethrough(T component, Boolean strikethrough) {
        component.setStrikethrough(strikethrough);
        return component;
    }

    public static <T extends BaseComponent> T setUnderlined(T component, Boolean underlined) {
        component.setUnderlined(underlined);
        return component;
    }

    public static <T extends BaseComponent> T setObfuscated(T component, Boolean obfuscated) {
        component.setObfuscated(obfuscated);
        return component;
    }

    public static <T extends BaseComponent> T addClickEvent(T component, ClickEvent event) {
        component.setClickEvent(event);
        return component;
    }

    public static <T extends BaseComponent> T addHoverEvent(T component, HoverEvent event) {
        component.setHoverEvent(event);
        return component;
    }

    public static <T extends BaseComponent> T addExtra(T component, BaseComponent extra) {
        component.addExtra(extra);
        return component;
    }

    public static <T extends BaseComponent> T addExtra(T component, String extra) {
        component.addExtra(extra);
        return component;
    }

    static {
        LinkedHashMap<ChatColor, CallSite> constantChatColors = new LinkedHashMap<ChatColor, CallSite>();
        for (char c : "0123456789abcdef".toCharArray()) {
            constantChatColors.put(ChatColor.getByChar((char)c), (CallSite)((Object)("&" + c)));
        }
        CONSTANT_CHAT_COLORS = Collections.unmodifiableMap(constantChatColors);
    }

    private static class EscapedConverter {
        private String text;
        private int to;
        private List<BaseComponent> components;
        private int index;
        private StringBuilder currentBuilder;
        private TextComponent currentComponent;

        EscapedConverter(String text, int from, int to) {
            this.text = Objects.requireNonNull(text);
            this.to = to;
            this.components = new ArrayList<BaseComponent>();
            this.index = from;
            this.currentBuilder = new StringBuilder();
            this.currentComponent = new TextComponent();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        BaseComponent convert() throws ParseException {
            while (this.index < this.to) {
                char current = this.text.charAt(this.index);
                if (current == '&') {
                    next = this.charAtOrException(this.index + 1);
                    if (next == '&') {
                        this.currentBuilder.append('&');
                        ++this.index;
                    } else {
                        ChatColor color;
                        if (ChatColor.getByChar((char)next) == null && next != 'x') throw new ParseException("unknown color code &" + next, this.index);
                        if (next == 'x') {
                            if (this.index + 2 + 6 > this.to) {
                                throw new ParseException("illegal hex code", this.index);
                            }
                            color = StringUtil.parseHexColor(this.text, this.index + 2);
                            if (color == null) {
                                throw new ParseException("illegal hex code", this.index);
                            }
                            this.index += 7;
                        } else {
                            color = ChatColor.getByChar((char)next);
                            ++this.index;
                        }
                        this.finishComponent(ComponentUtil.isColor(color) ? ComponentBuilder.FormatRetention.EVENTS : ComponentBuilder.FormatRetention.ALL);
                        if (color == ChatColor.BOLD) {
                            this.currentComponent.setBold(Boolean.valueOf(true));
                        } else if (color == ChatColor.ITALIC) {
                            this.currentComponent.setItalic(Boolean.valueOf(true));
                        } else if (color == ChatColor.MAGIC) {
                            this.currentComponent.setObfuscated(Boolean.valueOf(true));
                        } else if (color == ChatColor.STRIKETHROUGH) {
                            this.currentComponent.setStrikethrough(Boolean.valueOf(true));
                        } else if (color == ChatColor.UNDERLINE) {
                            this.currentComponent.setUnderlined(Boolean.valueOf(true));
                        } else {
                            this.currentComponent.setColor(color);
                        }
                    }
                } else if (current == '\\') {
                    next = this.charAtOrException(this.index + 1);
                    if (next == '\\' || next == '&' || next == '{' || next == '}') {
                        this.currentBuilder.append(next);
                        ++this.index;
                    } else if (next == 'n') {
                        this.currentBuilder.append('\n');
                        ++this.index;
                    } else if (next == 'r') {
                        char resetType = this.charAtOrException(this.index + 2);
                        if (resetType != 'a' && resetType != 'e' && resetType != 'f') {
                            throw new ParseException("unknown reset type " + resetType, this.index + 2);
                        }
                        this.finishComponent(resetType == 'a' ? ComponentBuilder.FormatRetention.NONE : (resetType == 'e' ? ComponentBuilder.FormatRetention.FORMATTING : ComponentBuilder.FormatRetention.EVENTS));
                        this.index += 2;
                    } else if (next == 'h') {
                        Content[] content;
                        HoverEvent.Action action;
                        char actionType = this.charAtOrException(this.index + 2);
                        if (actionType != 't' && actionType != 'i' && actionType != 'e') {
                            throw new ParseException("unknown action type " + actionType, this.index + 2);
                        }
                        if (this.charAtOrException(this.index + 3) != '{') {
                            throw new ParseException("expected {", this.index + 3);
                        }
                        int contentStartIndex = this.index + 4;
                        int contentEndIndex = this.findMatchingRightBrace(this.index + 3, this.to);
                        if (actionType == 't') {
                            action = HoverEvent.Action.SHOW_TEXT;
                            content = new Content[]{new Text(new BaseComponent[]{ComponentUtil.convertEscaped(this.text, contentStartIndex, contentEndIndex)})};
                        } else if (actionType == 'i') {
                            int itemCount;
                            action = HoverEvent.Action.SHOW_ITEM;
                            String[] itemStrings = this.text.substring(contentStartIndex, contentEndIndex).split("\\,", 3);
                            String itemId = itemStrings[0];
                            try {
                                itemCount = itemStrings.length < 2 || itemStrings[1].isEmpty() ? 1 : Integer.parseInt(itemStrings[1]);
                            }
                            catch (NumberFormatException e) {
                                throw new ParseException("illegal item count " + itemStrings[1], this.index + 3 + itemStrings[0].length() + 1);
                            }
                            ItemTag tag = itemStrings.length < 3 || itemStrings[2].isEmpty() ? null : ItemTag.ofNbt((String)this.convertEscapedString(itemStrings[2]));
                            content = new Content[]{new Item(itemId, itemCount, tag)};
                        } else if (actionType == 'e') {
                            UUID entityId;
                            action = HoverEvent.Action.SHOW_ENTITY;
                            int nameStartIndex = this.text.substring(contentStartIndex, contentEndIndex).indexOf(123) + contentStartIndex;
                            String[] entityStrings = this.text.substring(contentStartIndex, nameStartIndex < 0 ? contentEndIndex : nameStartIndex).split("\\,", 2);
                            String entityType = entityStrings[0];
                            try {
                                entityId = entityStrings.length < 2 || entityStrings[1].isEmpty() ? UUID.randomUUID() : UUID.fromString(entityStrings[1]);
                            }
                            catch (IllegalArgumentException e) {
                                throw new ParseException("illegal entity id " + entityStrings[1], this.index + 3 + entityStrings[0].length() + 1);
                            }
                            BaseComponent entityName = nameStartIndex < contentStartIndex ? null : ComponentUtil.convertEscaped(this.text, nameStartIndex + 1, this.findMatchingRightBrace(nameStartIndex, contentEndIndex));
                            content = new Content[]{new Entity(entityType, entityId.toString(), entityName)};
                        } else {
                            if ($assertionsDisabled) throw new ParseException("unknown action type " + actionType, this.index + 2);
                            throw new AssertionError();
                        }
                        this.finishComponent();
                        this.currentComponent.setHoverEvent(new HoverEvent(action, content));
                        this.index = contentEndIndex;
                    } else if (next == 'c') {
                        ClickEvent.Action action;
                        char actionType = this.charAtOrException(this.index + 2);
                        if (actionType == 'r') {
                            action = ClickEvent.Action.RUN_COMMAND;
                        } else if (actionType == 's') {
                            action = ClickEvent.Action.SUGGEST_COMMAND;
                        } else if (actionType == 'c') {
                            action = ClickEvent.Action.COPY_TO_CLIPBOARD;
                        } else if (actionType == 'p') {
                            action = ClickEvent.Action.CHANGE_PAGE;
                        } else if (actionType == 'u') {
                            action = ClickEvent.Action.OPEN_URL;
                        } else {
                            if (actionType != 'f') throw new ParseException("unknown action type " + actionType, this.index + 2);
                            throw new ParseException("action type f is rejected by clients", this.index + 2);
                        }
                        if (this.charAtOrException(this.index + 3) != '{') {
                            throw new ParseException("expected {", this.index + 3);
                        }
                        int contentStartIndex = this.index + 4;
                        int contentEndIndex = this.findMatchingRightBrace(this.index + 3, this.to);
                        String value = this.convertEscapedString(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent.setClickEvent(new ClickEvent(action, value));
                        this.index = contentEndIndex;
                    } else if (next == 'i') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String insertion = this.convertEscapedString(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent.setInsertion(insertion);
                        this.index = contentEndIndex;
                    } else if (next == 'f') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int fontStartIndex = this.index + 3;
                        int fontEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String fontString = this.text.substring(fontStartIndex, fontEndIndex);
                        this.finishComponent();
                        this.currentComponent.setFont(fontString);
                        this.index = fontEndIndex;
                    } else if (next == 't') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        int translationKeyEndIndex = this.text.substring(contentStartIndex, contentEndIndex).indexOf(123);
                        translationKeyEndIndex = translationKeyEndIndex < 0 ? contentEndIndex : (translationKeyEndIndex += contentStartIndex);
                        String translationKey = this.text.substring(contentStartIndex, translationKeyEndIndex);
                        ArrayList<BaseComponent> translationExtras = new ArrayList<BaseComponent>();
                        int blockStartIndex = translationKeyEndIndex;
                        while (blockStartIndex < contentEndIndex) {
                            if (this.charAtOrException(blockStartIndex) != '{') {
                                throw new ParseException("expected {", blockStartIndex);
                            }
                            int blockEndIndex = this.findMatchingRightBrace(blockStartIndex, contentEndIndex);
                            assert (blockEndIndex >= 0);
                            translationExtras.add(ComponentUtil.convertEscaped(this.text, blockStartIndex + 1, blockEndIndex));
                            blockStartIndex = blockEndIndex + 1;
                        }
                        this.finishComponent();
                        this.currentComponent.addExtra((BaseComponent)new TranslatableComponent(translationKey, translationExtras.toArray(new Object[translationExtras.size()])));
                        this.index = contentEndIndex;
                    } else if (next == 's') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String[] scoreStrings = this.text.substring(contentStartIndex, contentEndIndex).split("\\,", 3);
                        if (scoreStrings.length < 2) {
                            throw new ParseException("missing objective name", contentEndIndex);
                        }
                        String name = scoreStrings[0];
                        String objective = scoreStrings[1];
                        String value = scoreStrings.length < 3 ? "" : scoreStrings[2];
                        this.finishComponent();
                        this.currentComponent.addExtra((BaseComponent)new ScoreComponent(name, objective, value));
                        this.index = contentEndIndex;
                    } else if (next == '@') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String selector = this.text.substring(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent.addExtra((BaseComponent)new SelectorComponent(selector));
                        this.index = contentEndIndex;
                    } else {
                        if (next != 'k') throw new ParseException("unknown control sequence \\" + next, this.index);
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String keybind = this.text.substring(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent.addExtra((BaseComponent)new KeybindComponent(keybind));
                        this.index = contentEndIndex;
                    }
                } else if (current == '{') {
                    int closingIndex = this.findMatchingRightBrace(this.index, this.to);
                    this.finishComponent();
                    BaseComponent subComponent = ComponentUtil.convertEscaped(this.text, this.index + 1, closingIndex);
                    this.currentComponent.addExtra(subComponent);
                    this.index = closingIndex;
                } else {
                    if (current == '}') {
                        throw new ParseException("unmatched right brace", this.index);
                    }
                    this.currentBuilder.append(current);
                }
                ++this.index;
            }
            this.currentComponent.addExtra(this.currentBuilder.toString());
            this.components.add((BaseComponent)this.currentComponent);
            return new TextComponent(this.components.toArray(new BaseComponent[this.components.size()]));
        }

        private char charAtOrException(int i) throws ParseException {
            if (i >= this.to) {
                throw new ParseException("unexpected end of block", this.to);
            }
            return this.text.charAt(i);
        }

        private void finishComponent() {
            this.finishComponent(ComponentBuilder.FormatRetention.ALL);
        }

        private void finishComponent(ComponentBuilder.FormatRetention retention) {
            this.currentComponent.addExtra(this.currentBuilder.toString());
            this.components.add((BaseComponent)this.currentComponent);
            TextComponent newComponent = new TextComponent();
            newComponent.copyFormatting((BaseComponent)this.currentComponent, retention, true);
            this.currentComponent = newComponent;
            this.currentBuilder = new StringBuilder();
        }

        private int findMatchingRightBrace(int leftBraceIndex, int endIndex) throws ParseException {
            int depth = 0;
            block5: for (int i = leftBraceIndex; i < endIndex; ++i) {
                switch (this.text.charAt(i)) {
                    case '\\': {
                        ++i;
                        break;
                    }
                    case '{': {
                        ++depth;
                        break;
                    }
                    case '}': {
                        --depth;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (depth != 0) continue;
                return i;
            }
            throw new ParseException("unmatched left brace", leftBraceIndex);
        }

        private String convertEscapedString(String text) throws ParseException {
            return this.convertEscapedString(text, 0, text.length());
        }

        private String convertEscapedString(int from, int to) throws ParseException {
            return this.convertEscapedString(this.text, from, to);
        }

        private String convertEscapedString(String text, int from, int to) throws ParseException {
            StringBuilder result = new StringBuilder();
            for (int i = from; i < to; ++i) {
                char next;
                char curr = text.charAt(i);
                if (curr == '\\') {
                    if (i + 1 >= to) {
                        throw new ParseException("unexpected end of block", to);
                    }
                    next = text.charAt(i + 1);
                    if (next == '\\' || next == '&' || next == '{' || next == '}') {
                        result.append(next);
                    } else if (next == 'n') {
                        result.append('\n');
                    } else {
                        throw new ParseException("unknown simple control sequence \\" + next, i);
                    }
                    ++i;
                    continue;
                }
                if (curr == '&') {
                    if (i + 1 >= to) {
                        result.append('\u00a7');
                        continue;
                    }
                    next = text.charAt(i + 1);
                    if (next == '&') {
                        result.append('&');
                        ++i;
                        continue;
                    }
                    result.append('\u00a7');
                    continue;
                }
                result.append(curr);
            }
            return result.toString();
        }
    }
}

