/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.CharacterUtil;
import de.iani.cubesideutils.ChronoUtil;
import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.StringUtilCore;
import de.iani.cubesideutils.collections.ArrayUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class StringUtil {
    public static final Pattern COLOR_CHAR_PATTERN = Pattern.compile("\\\u00a7");
    public static final Pattern COLOR_CODES_PATTERN = Pattern.compile("\\\u00a7([0-9a-fk-or]|(x(\u00a7[0-9a-f]){6}))", 2);
    public static final ToIntFunction<String> CASE_IGNORING_HASHER = StringUtilCore.CASE_IGNORING_HASHER;
    public static final BiPredicate<String, String> CASE_IGNORING_EQUALITY = StringUtilCore.CASE_IGNORING_EQUALITY;
    public static final ToIntFunction<String> CASE_AND_COLORS_IGNORING_HASHER = s -> {
        if (s == null) {
            return 0;
        }
        return CASE_IGNORING_HASHER.applyAsInt(ChatColor.stripColor((String)s));
    };
    public static final BiPredicate<String, String> CASE_AND_COLORS_IGNORING_EQUALITY = (s1, s2) -> {
        if (s1 == null || s2 == null) {
            return s1 == null && s2 == null;
        }
        s1 = ChatColor.stripColor((String)s1);
        s2 = ChatColor.stripColor((String)s2);
        return s1.equalsIgnoreCase((String)s2);
    };
    public static final Set<String> TRUE_STRINGS;
    public static final Set<String> FALSE_STRINGS;
    public static final Pattern SPACES_AND_UNDERSCORES_PATTERN;
    private static final Pattern PIPE_PATTERN;
    private static final Pattern REMOVE_PIPE_PATTERN;
    private static final Pattern ESCAPE_CHARACTER_PATTERN;
    private static final Set<Character> CHARS_ILLEGAL_IN_FILENAME;
    private static final NavigableMap<Integer, String> ROMAN_NUMBER_MAP;
    public static final String DATE_FORMAT_STRING = "dd.MM.yyyy";
    public static final String TIME_FORMAT_STRING = "HH:mm";
    public static final String TIME_SECONDS_FORMAT_STRING = "HH:mm:ss";
    public static final String DATE_AND_TIME_FORMAT_STRING = "dd.MM.yyyy HH:mm";
    public static final String DATE_AND_TIME_SECONDS_FORMAT_STRING = "dd.MM.yyyy HH:mm:ss";
    public static final String TIMESTAMP_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat dateFormat;
    private static final DateFormat dateAndTimeFormat;
    private static final DateFormat dateAndTimeSecondsFormat;
    private static final DateFormat timestampFormat;

    private StringUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static String capitalizeFirstLetter(String s, boolean replaceUnderscores) {
        char[] cap = s.toCharArray();
        boolean lastSpace = true;
        for (int i = 0; i < cap.length; ++i) {
            char c = cap[i];
            if (c == '_') {
                if (replaceUnderscores) {
                    c = ' ';
                }
                lastSpace = true;
            } else if (c >= '0' && c <= '9' || c == '(' || c == ')') {
                lastSpace = true;
            } else {
                c = lastSpace ? Character.toUpperCase(c) : Character.toLowerCase(c);
                lastSpace = false;
            }
            cap[i] = c;
        }
        return new String(cap);
    }

    public static String replaceLast(String in, String sequence, String replacement) {
        int index = in.lastIndexOf(sequence);
        if (index < 0) {
            return in;
        }
        return in.substring(0, index) + replacement + in.substring(index + sequence.length(), in.length());
    }

    public static boolean startsWithIgnoreCase(String arg, String prefix) {
        if (arg.length() < prefix.length()) {
            return false;
        }
        return arg.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static String repeat(String arg, int times) {
        if (times <= 1) {
            if (times == 1) {
                return arg;
            }
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            builder.append(arg);
        }
        return builder.toString();
    }

    public static String indent(int indention) {
        return StringUtil.repeat(" ", indention);
    }

    @Deprecated
    public static String mcIndent(int indention) {
        return StringUtil.indent(indention);
    }

    public static boolean containsWord(String string, String word) {
        return Pattern.compile("\\b" + Pattern.quote(word) + "\\b").matcher(string).find();
    }

    public static String exceptionToString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String convertColors(String text) {
        return StringUtil.parseColors(text, false);
    }

    public static String stripColors(String text) {
        return StringUtil.parseColors(text, true);
    }

    private static String parseColors(String text, boolean remove) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char next;
            char current = text.charAt(i);
            if (current == '&' && i + 1 < len && (ChatColor.getByChar((char)(next = text.charAt(i + 1))) != null || next == '&' || next == 'x')) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(text, 0, i);
                }
                ++i;
                if (next != '&') {
                    if (next == 'x') {
                        ChatColor hex = StringUtil.parseHexColor(text, i + 1);
                        if (hex == null) {
                            builder.append(current).append(next);
                            continue;
                        }
                        if (!remove) {
                            builder.append(hex);
                        }
                        i += 6;
                        continue;
                    }
                    if (remove) continue;
                    builder.append('\u00a7').append(next);
                    continue;
                }
            }
            if (builder == null) continue;
            builder.append(current);
        }
        return builder == null ? text : builder.toString();
    }

    public static ChatColor parseHexColor(String text, int startIndex) {
        if (text.length() - startIndex < 6) {
            return null;
        }
        StringBuilder hexString = new StringBuilder("#");
        for (int i = 0; i < 6; ++i) {
            char c = Character.toLowerCase(text.charAt(i + startIndex));
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f')) {
                return null;
            }
            hexString.append(c);
        }
        return ChatColor.of((String)hexString.toString());
    }

    public static Pair<String, String> splitAtPipe(String args) {
        Matcher matcher = PIPE_PATTERN.matcher(args);
        if (!matcher.find()) {
            return null;
        }
        String first = args.substring(0, matcher.start());
        String second = matcher.end() >= args.length() ? "" : args.substring(matcher.end());
        first = REMOVE_PIPE_PATTERN.matcher(first).replaceAll("$1");
        second = REMOVE_PIPE_PATTERN.matcher(second).replaceAll("$1");
        return new Pair<String, String>(first, second);
    }

    public static String revertColors(String converted) {
        if (converted == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < converted.length(); ++i) {
            char c = converted.charAt(i);
            if (c == '\u00a7') {
                if (converted.length() > i + 1 && converted.charAt(i + 1) == 'x') {
                    if (i + 14 > converted.length()) {
                        builder.append("&");
                        continue;
                    }
                    String hexString = converted.substring(i, i + 14);
                    if (!COLOR_CODES_PATTERN.matcher(hexString).matches()) {
                        builder.append("&");
                        continue;
                    }
                    builder.append("&").append(COLOR_CHAR_PATTERN.matcher(hexString).replaceAll(""));
                    i += 13;
                    continue;
                }
                builder.append("&");
                continue;
            }
            if (c == '&') {
                builder.append("&&");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String convertEscaped(String text) {
        Matcher matcher = ESCAPE_CHARACTER_PATTERN.matcher(text);
        StringBuffer buffer = null;
        while (matcher.find()) {
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            char escaped = matcher.group().charAt(1);
            matcher.appendReplacement(buffer, switch (escaped) {
                case '\\' -> "\\\\";
                case 'n' -> "\n";
                default -> String.valueOf(escaped);
            });
        }
        if (buffer == null) {
            return text;
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String revertEscaped(String text) {
        text = text.replaceAll("\\\\", "\\\\\\\\");
        text = text.replaceAll("\\n", "\\\\n");
        return text;
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength) {
        return StringUtil.breakLines(text, lineLength, COLOR_CODES_PATTERN);
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength, boolean forceLineBreak) {
        return StringUtil.breakLines(text, lineLength, COLOR_CODES_PATTERN, forceLineBreak);
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength, boolean forceLineBreak, boolean preserveColorCodes) {
        return StringUtil.breakLines(text, lineLength, COLOR_CODES_PATTERN, forceLineBreak, preserveColorCodes);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength) {
        return StringUtil.breakLines(text, lineLength, ignoreForLength, false);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength, boolean forceLineBreak) {
        return StringUtil.breakLines(text, lineLength, ignoreForLength, forceLineBreak, ignoreForLength == COLOR_CODES_PATTERN);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength, boolean forceLineBreak, boolean preserveColorCodes) {
        if (lineLength <= 0) {
            throw new IllegalArgumentException("lineLength must be positive");
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentBuilder = new StringBuilder();
        char[] chars = text.toCharArray();
        int index = 0;
        int lastBlank = -1;
        int lastBreak = 0;
        boolean magic = false;
        boolean bold = false;
        boolean strikethrough = false;
        boolean underline = false;
        boolean italic = false;
        ChatColor color = null;
        int ignoreColorsUntil = 0;
        int currentPrefixLength = 0;
        while (index < chars.length) {
            char current = chars[index];
            if (current == '\n') {
                lastBreak = ++index;
                result.add(currentBuilder.toString());
                currentBuilder = new StringBuilder();
                if (!preserveColorCodes) continue;
                currentPrefixLength = StringUtil.addColorCodes(currentBuilder, magic, bold, strikethrough, underline, italic, color);
                continue;
            }
            if (current == ' ') {
                lastBlank = index;
            } else if (preserveColorCodes && current == '\u00a7' && index + 1 < chars.length && index >= ignoreColorsUntil) {
                char next = chars[index + 1];
                ChatColor col = null;
                if (next == 'x') {
                    col = StringUtil.parseHexColorSpigot(chars, index + 2);
                    if (col != null) {
                        ignoreColorsUntil = index + 2 + 12;
                    }
                } else {
                    col = ChatColor.getByChar((char)next);
                }
                if (col != null) {
                    if (col.equals((Object)ChatColor.MAGIC)) {
                        magic = true;
                    } else if (col.equals((Object)ChatColor.BOLD)) {
                        bold = true;
                    } else if (col.equals((Object)ChatColor.STRIKETHROUGH)) {
                        strikethrough = true;
                    } else if (col.equals((Object)ChatColor.UNDERLINE)) {
                        underline = true;
                    } else if (col.equals((Object)ChatColor.ITALIC)) {
                        italic = true;
                    } else {
                        color = col == ChatColor.RESET ? null : col;
                        magic = false;
                        bold = false;
                        strikethrough = false;
                        underline = false;
                        italic = false;
                    }
                }
            }
            currentBuilder.append(current);
            if (StringUtil.tooLong(currentBuilder.toString(), lineLength, ignoreForLength)) {
                if (lastBlank > lastBreak) {
                    int start = lastBlank + currentPrefixLength - lastBreak;
                    int end = currentBuilder.length();
                    currentBuilder.delete(start, end);
                    result.add(currentBuilder.toString());
                    currentBuilder = new StringBuilder();
                    if (preserveColorCodes) {
                        currentPrefixLength = StringUtil.addColorCodes(currentBuilder, magic, bold, strikethrough, underline, italic, color);
                    }
                    lastBreak = index = lastBlank + 1;
                    continue;
                }
                if (forceLineBreak && index != lastBreak) {
                    currentBuilder.delete(currentBuilder.length() - 1, currentBuilder.length());
                    result.add(currentBuilder.toString());
                    currentBuilder = new StringBuilder();
                    if (preserveColorCodes) {
                        currentPrefixLength = StringUtil.addColorCodes(currentBuilder, magic, bold, strikethrough, underline, italic, color);
                    }
                    lastBreak = index;
                    continue;
                }
            }
            ++index;
        }
        if (currentBuilder.length() > 0) {
            result.add(currentBuilder.toString());
        }
        return result;
    }

    private static ChatColor parseHexColorSpigot(char[] text, int startIndex) {
        if (text.length - startIndex < 12) {
            return null;
        }
        StringBuilder hexString = new StringBuilder("#");
        for (int i = 0; i < 6; ++i) {
            if (text[2 * i + startIndex] != '\u00a7') {
                return null;
            }
            char c = Character.toLowerCase(text[2 * i + 1 + startIndex]);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f')) {
                return null;
            }
            hexString.append(c);
        }
        return ChatColor.of((String)hexString.toString());
    }

    private static boolean tooLong(String string, int limit, Pattern ignoreForLength) {
        string = ignoreForLength == null ? string : ignoreForLength.matcher(string).replaceAll("");
        return string.length() > limit;
    }

    private static int addColorCodes(StringBuilder builder, boolean magic, boolean bold, boolean strikethrough, boolean underline, boolean italic, ChatColor color) {
        int length = 0;
        if (color != null) {
            String colorString = color.toString();
            builder.append(colorString);
            length += colorString.length();
        }
        if (magic) {
            builder.append(ChatColor.MAGIC);
            length += 2;
        }
        if (bold) {
            builder.append(ChatColor.BOLD);
            length += 2;
        }
        if (strikethrough) {
            builder.append(ChatColor.STRIKETHROUGH);
            length += 2;
        }
        if (underline) {
            builder.append(ChatColor.UNDERLINE);
            length += 2;
        }
        if (italic) {
            builder.append(ChatColor.ITALIC);
            length += 2;
        }
        return length;
    }

    public static boolean isSafeFilename(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!CHARS_ILLEGAL_IN_FILENAME.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalCommandName(String name) {
        return !name.contains(" ");
    }

    public static String toRomanNumber(int arg) {
        if (arg == 0) {
            return "0";
        }
        if (arg < 0) {
            return "-" + StringUtil.toRomanNumber(-arg);
        }
        int i = ROMAN_NUMBER_MAP.floorKey(arg);
        if (arg == i) {
            return (String)ROMAN_NUMBER_MAP.get(arg);
        }
        return (String)ROMAN_NUMBER_MAP.get(i) + StringUtil.toRomanNumber(arg - i);
    }

    public static String formatTimespan(long ms) {
        return StringUtil.formatTimespan(ms, "d", "h", "m", "s", "", "");
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter) {
        return StringUtil.formatTimespan(ms, d, h, m, s, delimiter, lastDelimiter, true);
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter, boolean dropAllLowerIfZero) {
        return StringUtil.formatTimespan(ms, d, h, m, s, delimiter, lastDelimiter, dropAllLowerIfZero, false);
    }

    public static String formatTimespan(long ms, String d, String h, String m, String s, String delimiter, String lastDelimiter, boolean dropAllLowerIfZero, boolean forceMinutesAndTwoDigitsForTime) {
        String result;
        long days = ms / 86400000L;
        long hours = (ms -= days * 86400000L) / 3600000L;
        long minutes = (ms -= hours * 3600000L) / 60000L;
        long seconds = (ms -= minutes * 60000L) / 1000L;
        double lessThanSeconds = (double)(ms -= seconds * 1000L) / 1000.0;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        boolean allNext = false;
        if (days != 0L) {
            first = false;
            allNext = !dropAllLowerIfZero;
            builder.append(days);
            builder.append(d);
        }
        if (allNext || hours != 0L) {
            if (!first) {
                if (allNext || minutes != 0L || seconds != 0L || lessThanSeconds != 0.0) {
                    builder.append(delimiter);
                } else {
                    builder.append(lastDelimiter);
                }
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && hours < 10L) {
                builder.append('0');
            }
            builder.append(hours);
            builder.append(h);
        }
        if (allNext || forceMinutesAndTwoDigitsForTime || minutes != 0L) {
            if (!first) {
                if (allNext || seconds != 0L || lessThanSeconds != 0.0) {
                    builder.append(delimiter);
                } else {
                    builder.append(lastDelimiter);
                }
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && minutes < 10L) {
                builder.append('0');
            }
            builder.append(minutes);
            builder.append(m);
        }
        if (allNext || seconds != 0L || lessThanSeconds != 0.0) {
            if (!first) {
                builder.append(lastDelimiter);
            }
            first = false;
            boolean bl = allNext = !dropAllLowerIfZero;
            if (forceMinutesAndTwoDigitsForTime && seconds < 10L) {
                builder.append('0');
            }
            builder.append(seconds);
            if (lessThanSeconds != 0.0) {
                builder.append(".");
                Object lessThanSecondsString = "" + lessThanSeconds;
                lessThanSecondsString = ((String)lessThanSecondsString).substring(((String)lessThanSecondsString).indexOf(46) + 1);
                builder.append((String)lessThanSecondsString);
            }
            builder.append(s);
        }
        if (!(result = builder.toString().trim()).equals("")) {
            return result;
        }
        return ("0" + s).trim();
    }

    public static String formatTimespanClassic(long ms) {
        return StringUtil.formatTimespan(ChronoUtil.roundTimespan(ms, ChronoUnit.SECONDS), "", "", "", "", ":", ":", false, true);
    }

    public static long parseTimespan(String arg) {
        return StringUtil.parseTimespan(arg, "d", "h", "m", "s", "");
    }

    public static long parseTimespan(String arg, String d, String h, String m, String s, String delimiter) {
        return StringUtil.parseTimespan(arg, d, h, m, s, delimiter, delimiter);
    }

    public static long parseTimespan(String arg, String d, String h, String m, String s, String delimiter1, String delimiter2) {
        String secondExpression;
        String minuteExpression;
        String hourExpression;
        String delimiterExpression = delimiter1.isEmpty() && delimiter2.isEmpty() ? "(\\Z??)" : "((\\Z)" + (String)(!delimiter1.isEmpty() ? "|(" + Pattern.quote(delimiter1) + ")" : "") + (String)(!delimiter2.isEmpty() ? "|(" + Pattern.quote(delimiter2) + ")" : "") + ")";
        String dayExpression = "(?<days>(\\d+))" + Pattern.quote(d) + delimiterExpression;
        Pattern sanityPattern = Pattern.compile("\\A((" + dayExpression + ")?(" + (hourExpression = "(?<hours>(\\d+))" + Pattern.quote(h) + delimiterExpression) + ")?(" + (minuteExpression = "(?<minutes>(\\d+))" + Pattern.quote(m) + delimiterExpression) + ")?(" + (secondExpression = "(?<seconds>(\\d+(\\.\\d+)?))" + Pattern.quote(s) + delimiterExpression) + ")?)*\\Z", 2);
        if (!sanityPattern.matcher(arg).matches()) {
            throw new IllegalArgumentException("Not a timespan.");
        }
        Pattern dayPattern = Pattern.compile(dayExpression, 2);
        Pattern hourPattern = Pattern.compile(hourExpression, 2);
        Pattern minutePattern = Pattern.compile(minuteExpression, 2);
        Pattern secondPattern = Pattern.compile(secondExpression, 2);
        long result = 0L;
        Matcher dayMatcher = dayPattern.matcher(arg);
        while (dayMatcher.find()) {
            result += Long.parseLong(dayMatcher.group("days")) * 24L * 60L * 60L * 1000L;
        }
        Matcher hourMatcher = hourPattern.matcher(arg);
        while (hourMatcher.find()) {
            result += Long.parseLong(hourMatcher.group("hours")) * 60L * 60L * 1000L;
        }
        Matcher minuteMatcher = minutePattern.matcher(arg);
        while (minuteMatcher.find()) {
            result += Long.parseLong(minuteMatcher.group("minutes")) * 60L * 1000L;
        }
        Matcher secondMatcher = secondPattern.matcher(arg);
        while (secondMatcher.find()) {
            result += (long)(Double.parseDouble(secondMatcher.group("seconds")) * 1000.0);
        }
        return result;
    }

    public static synchronized String formatDate(long date) {
        return StringUtil.formatDate(new Date(date));
    }

    public static synchronized String formatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if (hour == 0 && minute == 0 && second == 0) {
            return dateFormat.format(date);
        }
        return (second == 0 ? dateAndTimeFormat.format(date) : dateAndTimeSecondsFormat.format(date)) + " Uhr";
    }

    public static synchronized String formatDate(long date, boolean displayTime) {
        return StringUtil.formatDate(new Date(date), displayTime);
    }

    public static synchronized String formatDate(Date date, boolean displayTime) {
        return StringUtil.formatDate(date, displayTime, displayTime);
    }

    public static synchronized String formatDate(long date, boolean displayTime, boolean displaySeconds) {
        return StringUtil.formatDate(new Date(date), displayTime, displaySeconds);
    }

    public static synchronized String formatDate(Date date, boolean displayTime, boolean displaySeconds) {
        if (!displayTime) {
            return dateFormat.format(date);
        }
        if (!displaySeconds) {
            return dateAndTimeFormat.format(date) + " Uhr";
        }
        return dateAndTimeSecondsFormat.format(date) + " Uhr";
    }

    public static synchronized Date parseDate(String arg) {
        if (arg.isEmpty()) {
            throw new IllegalArgumentException("empty String");
        }
        String[] args = arg.split(" ");
        if (args.length > 2) {
            throw new IllegalArgumentException("Only one space allowed.");
        }
        try {
            if (args.length == 1) {
                return dateFormat.parse(arg);
            }
            String[] args2 = args[1].split("\\:");
            if (args2.length < 2 || args2.length > 3) {
                throw new IllegalArgumentException("Only one or two colons allowed in time block.");
            }
            if (args2.length == 2) {
                return dateAndTimeFormat.parse(arg);
            }
            return dateAndTimeSecondsFormat.parse(arg);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static synchronized String formatTimestamp(long date) {
        return StringUtil.formatTimestamp(new Date(date));
    }

    public static synchronized String formatTimestamp(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return timestampFormat.format(date);
    }

    public static String flip(String s) {
        char[] data = s.toCharArray();
        ArrayUtils.flip(data);
        return String.valueOf(data);
    }

    public static String tryPlural(String of) {
        String lower = of.toLowerCase();
        if (lower.endsWith("sheep")) {
            return of;
        }
        if (lower.endsWith("us")) {
            return of.substring(0, of.length() - 2) + "i";
        }
        if (lower.endsWith("s")) {
            return of;
        }
        if (lower.endsWith("sh") || lower.endsWith("ch") || lower.endsWith("is") || lower.endsWith("x") || lower.endsWith("z") || lower.endsWith("o")) {
            return of + "es";
        }
        if (lower.endsWith("f") || lower.endsWith("fe")) {
            return of.substring(0, of.lastIndexOf(102)) + "ves";
        }
        if (lower.endsWith("y") && lower.length() >= 2 && CharacterUtil.isConsonant(lower.charAt(lower.length() - 2))) {
            return of.substring(0, of.length() - 1) + "ies";
        }
        if (lower.endsWith("man")) {
            return of.substring(0, of.length() - 2) + "en";
        }
        return of + "s";
    }

    static {
        Set trueStrings = Collections.newSetFromMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        trueStrings.addAll(Arrays.asList("1", "true", "t", "ja", "j", "wahr", "w"));
        TRUE_STRINGS = Collections.unmodifiableSet(trueStrings);
        Set falseStrings = Collections.newSetFromMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        falseStrings.addAll(Arrays.asList("0", "false", "f", "nein", "n", "falsch"));
        FALSE_STRINGS = Collections.unmodifiableSet(falseStrings);
        SPACES_AND_UNDERSCORES_PATTERN = Pattern.compile("[\\ \\_]");
        PIPE_PATTERN = Pattern.compile("( |\\A)\\|( |\\Z)");
        REMOVE_PIPE_PATTERN = Pattern.compile("\\|([^\\|])");
        ESCAPE_CHARACTER_PATTERN = Pattern.compile("\\\\.");
        HashSet<Character> illegals = new HashSet<Character>();
        for (char c = '\u0000'; c <= '\u001f'; c = (char)(c + '\u0001')) {
            illegals.add(Character.valueOf(c));
        }
        for (char c : new char[]{'|', '\\', '/', '?', '!', '*', '+', '%', '<', '>', '\"', ':', ';', ',', '.', '=', '[', ']', '@', '\u007f'}) {
            illegals.add(Character.valueOf(c));
        }
        CHARS_ILLEGAL_IN_FILENAME = Collections.unmodifiableSet(illegals);
        TreeMap<Integer, String> romanNumberMap = new TreeMap<Integer, String>();
        romanNumberMap.put(1000, "M");
        romanNumberMap.put(900, "CM");
        romanNumberMap.put(500, "D");
        romanNumberMap.put(400, "CD");
        romanNumberMap.put(100, "C");
        romanNumberMap.put(90, "XC");
        romanNumberMap.put(50, "L");
        romanNumberMap.put(40, "XL");
        romanNumberMap.put(10, "X");
        romanNumberMap.put(9, "IX");
        romanNumberMap.put(5, "V");
        romanNumberMap.put(4, "IV");
        romanNumberMap.put(1, "I");
        ROMAN_NUMBER_MAP = Collections.unmodifiableNavigableMap(romanNumberMap);
        dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        dateAndTimeFormat = new SimpleDateFormat(DATE_AND_TIME_FORMAT_STRING);
        dateAndTimeSecondsFormat = new SimpleDateFormat(DATE_AND_TIME_SECONDS_FORMAT_STRING);
        timestampFormat = new SimpleDateFormat(TIMESTAMP_FORMAT_STRING);
    }
}

