/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.loot.LootTables;
import org.bukkit.potion.PotionEffectType;

public class KeyedUtil {
    private static final Map<NamespacedKey, Keyed> internalRegistry = new HashMap<NamespacedKey, Keyed>();
    public static final Map<NamespacedKey, Keyed> registry = Collections.unmodifiableMap(internalRegistry);

    private KeyedUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    private static <T extends Keyed> void addToRegistry(T[] values) {
        for (T t : values) {
            internalRegistry.put(t.getKey(), (Keyed)t);
        }
    }

    private static <T extends Keyed> void addToRegistry(Collection<T> values) {
        for (Keyed t : values) {
            internalRegistry.put(t.getKey(), t);
        }
    }

    public static boolean registerElement(Keyed k) {
        return internalRegistry.putIfAbsent(k.getKey(), k) == null;
    }

    public static <T extends Keyed> T getFromRegistry(NamespacedKey k) {
        return (T)internalRegistry.get(k);
    }

    static {
        KeyedUtil.addToRegistry((Keyed[])Art.values());
        KeyedUtil.addToRegistry((Keyed[])Attribute.values());
        KeyedUtil.addToRegistry((Keyed[])Biome.values());
        KeyedUtil.addToRegistry((Keyed[])Cat.Type.values());
        KeyedUtil.addToRegistry((Keyed[])Enchantment.values());
        KeyedUtil.addToRegistry((Keyed[])EntityType.values());
        KeyedUtil.addToRegistry((Keyed[])Fluid.values());
        KeyedUtil.addToRegistry((Keyed[])Frog.Variant.values());
        KeyedUtil.addToRegistry(GameEvent.values());
        KeyedUtil.addToRegistry((Keyed[])LootTables.values());
        KeyedUtil.addToRegistry((Keyed[])Material.values());
        KeyedUtil.addToRegistry(MemoryKey.values());
        KeyedUtil.addToRegistry(MusicInstrument.values());
        KeyedUtil.addToRegistry((Keyed[])PotionEffectType.values());
        KeyedUtil.addToRegistry((Keyed[])Sound.values());
        KeyedUtil.addToRegistry((Keyed[])Statistic.values());
        KeyedUtil.addToRegistry((Keyed[])Villager.Profession.values());
        KeyedUtil.addToRegistry((Keyed[])Villager.Type.values());
    }
}

