/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.serialization;

import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.serialization.StringSerializable;
import de.iani.cubesideutils.serialization.StringSerialization;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class RecordSerialization {
    public static <T extends Record> Map<String, Object> serialize(T record) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (RecordComponent component : record.getClass().getRecordComponents()) {
            try {
                result.put(component.getName(), component.getAccessor().invoke(record, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("expected record component accessor methods to be present and public");
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException f = (RuntimeException)throwable;
                    throw f;
                }
                throwable = e.getCause();
                if (throwable instanceof Error) {
                    Error f = (Error)throwable;
                    throw f;
                }
                throw new RuntimeException("unexpected type of throwable", e.getCause());
            }
        }
        return result;
    }

    public static <T extends Record> T deserialize(Class<T> recordClass, Map<String, Object> serialized) {
        RecordComponent[] components = recordClass.getRecordComponents();
        Object[] constructorArgs = new Object[components.length];
        for (int i = 0; i < components.length; ++i) {
            constructorArgs[i] = serialized.get(components[i].getName());
        }
        try {
            return (T)((Record)recordClass.getConstructors()[0].newInstance(constructorArgs));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new RuntimeException("expected record constructor to be present and public");
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException f = (RuntimeException)throwable;
                throw f;
            }
            throwable = e.getCause();
            if (throwable instanceof Error) {
                Error f = (Error)throwable;
                throw f;
            }
            throw new RuntimeException("unexpected type of throwable", e.getCause());
        }
    }

    public static <T extends Record> String serializeToString(T record) {
        StringBuilder result = new StringBuilder();
        for (RecordComponent component : record.getClass().getRecordComponents()) {
            Object value;
            if (!result.isEmpty()) {
                result.append(" ; ");
            }
            try {
                value = component.getAccessor().invoke(record, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("expected record component accessor methods to be present and public");
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException f = (RuntimeException)throwable;
                    throw f;
                }
                throwable = e.getCause();
                if (throwable instanceof Error) {
                    Error f = (Error)throwable;
                    throw f;
                }
                throw new RuntimeException("unexpected type of throwable", e.getCause());
            }
            Pair serialized = StringSerialization.serialize((Object)value);
            result.append(component.getName()).append(":");
            result.append((String)serialized.first()).append(":");
            result.append(RecordSerialization.escape((String)serialized.second()));
        }
        return result.toString();
    }

    public static <T extends Record> T deserializeFromString(Class<T> recordClass, String serialized) {
        String[] compStrings;
        Pattern partSeperatorPattern = Pattern.compile(Pattern.quote(":"));
        HashMap<String, Object> componentValues = new HashMap<String, Object>();
        for (String compString : compStrings = serialized.split(Pattern.quote(" ; "))) {
            String[] serializationParts = partSeperatorPattern.split(compString, 3);
            String compName = serializationParts[0];
            String compType = serializationParts[1];
            String compSerialized = RecordSerialization.unescape(serializationParts[2]);
            Object compValue = StringSerialization.deserialize((String)compType, (String)compSerialized);
            componentValues.put(compName, compValue);
        }
        RecordComponent[] components = recordClass.getRecordComponents();
        Object[] constructorArgs = new Object[components.length];
        for (int i = 0; i < components.length; ++i) {
            constructorArgs[i] = componentValues.get(components[i].getName());
        }
        try {
            return (T)((Record)recordClass.getConstructors()[0].newInstance(constructorArgs));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new RuntimeException("expected record constructor to be present and public");
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException f = (RuntimeException)throwable;
                throw f;
            }
            throwable = e.getCause();
            if (throwable instanceof Error) {
                Error f = (Error)throwable;
                throw f;
            }
            throw new RuntimeException("unexpected type of throwable", e.getCause());
        }
    }

    private static String escape(String arg) {
        if (!arg.contains(";")) {
            return arg;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            builder.append(c);
            if (c != ';') continue;
            while (i < arg.length() - 1 && arg.charAt(i + 1) == ';') {
                builder.append(';');
                ++i;
            }
            builder.append(';');
        }
        return builder.toString();
    }

    private static String unescape(String arg) {
        if (!arg.contains(";")) {
            return arg;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < arg.length() - 1; ++i) {
            char c = arg.charAt(i);
            if (c != ';') {
                builder.append(c);
                continue;
            }
            while (i < arg.length() - 1 && arg.charAt(i + 1) == ';') {
                builder.append(';');
                ++i;
            }
        }
        return builder.toString();
    }

    public static interface SerializableRecord
    extends ConfigurationSerializableRecord,
    StringSerializableRecord {
    }

    public static interface StringSerializableRecord
    extends StringSerializable {
        default public String serializeToString() {
            return RecordSerialization.serializeToString((Record)((Object)this));
        }
    }

    public static interface ConfigurationSerializableRecord
    extends ConfigurationSerializable {
        default public Map<String, Object> serialize() {
            return RecordSerialization.serialize((Record)((Object)this));
        }
    }
}

