/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.map;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.bukkit.map.MapPalette;

public class FloydSteinbergDithering {
    public static void direct(BufferedImage image) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int oldColor = image.getRGB(x, y);
                int nearestColor = FloydSteinbergDithering.getNearestMinecraftMapColor(oldColor);
                image.setRGB(x, y, nearestColor);
            }
        }
    }

    public static void applyDithering(BufferedImage image) {
        FloydSteinbergDithering.applyDithering(image, 1);
    }

    public static void applyDithering(BufferedImage image, int ditherReductionFactor) {
        Preconditions.checkArgument((ditherReductionFactor >= 1 ? 1 : 0) != 0, (Object)"ditherReductionFactor must be postive");
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int updated;
                int oldColor = image.getRGB(x, y);
                int nearestColor = FloydSteinbergDithering.getNearestMinecraftMapColor(oldColor);
                image.setRGB(x, y, nearestColor);
                int a = oldColor >> 24 & 0xFF;
                int r = oldColor >> 16 & 0xFF;
                int g = oldColor >> 8 & 0xFF;
                int b = oldColor & 0xFF;
                int na = nearestColor >> 24 & 0xFF;
                int nr = nearestColor >> 16 & 0xFF;
                int ng = nearestColor >> 8 & 0xFF;
                int nb = nearestColor & 0xFF;
                int errA = a - na;
                int errR = r - nr;
                int errG = g - ng;
                int errB = b - nb;
                if (x + 1 < image.getWidth()) {
                    updated = FloydSteinbergDithering.adjustPixel(image.getRGB(x + 1, y), errA, errR, errG, errB, 7, ditherReductionFactor);
                    image.setRGB(x + 1, y, updated);
                }
                if (y + 1 >= image.getHeight()) continue;
                updated = FloydSteinbergDithering.adjustPixel(image.getRGB(x, y + 1), errA, errR, errG, errB, 5, ditherReductionFactor);
                image.setRGB(x, y + 1, updated);
                if (x - 1 >= 0) {
                    updated = FloydSteinbergDithering.adjustPixel(image.getRGB(x - 1, y + 1), errA, errR, errG, errB, 3, ditherReductionFactor);
                    image.setRGB(x - 1, y + 1, updated);
                }
                if (x + 1 >= image.getWidth()) continue;
                updated = FloydSteinbergDithering.adjustPixel(image.getRGB(x + 1, y + 1), errA, errR, errG, errB, 1, ditherReductionFactor);
                image.setRGB(x + 1, y + 1, updated);
            }
        }
    }

    public static int getNearestMinecraftMapColor(int rgba) {
        return MapPalette.getColor((byte)MapPalette.matchColor((Color)new Color(rgba, true))).getRGB();
    }

    private static int adjustPixel(int colorRgb, int errA, int errR, int errG, int errB, int mul, int ditherReductionFactor) {
        int a = FloydSteinbergDithering.clampToByte((colorRgb >> 24 & 0xFF) + errA * mul / (16 * ditherReductionFactor));
        int r = FloydSteinbergDithering.clampToByte((colorRgb >> 16 & 0xFF) + errR * mul / (16 * ditherReductionFactor));
        int g = FloydSteinbergDithering.clampToByte((colorRgb >> 8 & 0xFF) + errG * mul / (16 * ditherReductionFactor));
        int b = FloydSteinbergDithering.clampToByte((colorRgb & 0xFF) + errB * mul / (16 * ditherReductionFactor));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int clampToByte(int value) {
        return Math.min(Math.max(value, 0), 255);
    }
}

