/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin.commands;

import de.iani.cubesideutils.StringUtil;
import de.iani.cubesideutils.bukkit.ChatUtilBukkit;
import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.commands.ArgsParser;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ListRankInformationCommand
extends SubCommand {
    public static final String COMMAND_PATH = "list";
    public static final String FULL_COMMAND = "ranks list";

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) {
        int page = 0;
        if (args.hasNext()) {
            page = args.getNext(0) - 1;
        }
        List msgs = CubesideUtilsBukkit.getInstance().getRanks().stream().map(rank -> {
            int priority = CubesideUtilsBukkit.getInstance().getPriority((String)rank);
            String permission = CubesideUtilsBukkit.getInstance().getPermission((String)rank);
            String prefix = CubesideUtilsBukkit.getInstance().getPrefix((String)rank);
            StringBuilder info = new StringBuilder((String)rank).append(": ");
            info.append("priority ").append(priority).append(", ");
            info.append("permission ").append(permission == null ? "-" : permission).append(", ");
            info.append("prefix ").append(StringUtil.revertColors((String)prefix));
            return new ChatUtilBukkit.StringMsg(info.toString());
        }).collect(Collectors.toList());
        ChatUtilBukkit.sendMessagesPaged(sender, msgs, page, "Rank Information", FULL_COMMAND);
        return true;
    }
}

