/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin.api.events;

import de.iani.cubesideutils.Pair;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerOptionsRetrievedEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private CommandSender sender;
    private OfflinePlayer player;
    private boolean cancelled;
    private TreeSet<Pair<Integer, BaseComponent[]>> options;

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public PlayerOptionsRetrievedEvent(CommandSender sender, OfflinePlayer playerData) {
        this.sender = Objects.requireNonNull(sender);
        this.player = Objects.requireNonNull(playerData);
        this.cancelled = false;
        this.options = new TreeSet((p1, p2) -> Integer.compare((Integer)p1.first, (Integer)p2.first));
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public void addOptions(int priority, BaseComponent ... options) {
        this.options.add((Pair<Integer, BaseComponent[]>)new Pair((Object)priority, (Object)new BaseComponent[]{new TextComponent(options), new TextComponent(" ")}));
    }

    public BaseComponent[] getOptions() {
        return this.options.stream().map(Pair::second).flatMap(Arrays::stream).collect(Collectors.toList()).toArray(new BaseComponent[0]);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public HandlerList getHandlers() {
        return handlers;
    }
}

