/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.iani.cubesideutils.Triple;
import de.iani.cubesideutils.bukkit.plugin.CachedOfflinePlayer;
import de.iani.cubesideutils.bukkit.plugin.OnlinePlayerDataImpl;
import de.iani.cubesideutils.bukkit.plugin.PlayerDataImplBukkit;
import de.iani.cubesideutils.plugin.UtilsDatabase;
import de.iani.cubesideutils.sql.SQLConfig;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;

public class UtilsDatabaseBukkit
extends UtilsDatabase<PlayerDataImplBukkit> {
    public UtilsDatabaseBukkit(SQLConfig sqlConfig) throws SQLException {
        super(sqlConfig);
    }

    public OnlinePlayerDataImpl getOnlinePlayerData(UUID playerId, boolean insertIfMissing, long lastAction, boolean manuallySetAfk) throws SQLException {
        return (OnlinePlayerDataImpl)this.getPlayerData(playerId, true, insertIfMissing, lastAction, manuallySetAfk);
    }

    public PlayerDataImplBukkit getPlayerData(UUID playerId, boolean isOnline, boolean insertIfMissing, long lastAction, boolean manuallySetAfk) throws SQLException {
        UtilsDatabase.PlayerDataStruct data = this.getPlayerDataData(playerId, isOnline, insertIfMissing, lastAction, manuallySetAfk);
        if (data == null) {
            return null;
        }
        long firstJoin = data.firstJoin;
        long lastJoin = data.lastJoin;
        long lastSeen = data.lastSeen;
        boolean afk = data.afk;
        String lastName = data.lastName;
        String rank = data.rank;
        return isOnline ? new OnlinePlayerDataImpl(playerId, firstJoin, lastJoin, lastSeen, afk, lastAction, manuallySetAfk, lastName, rank) : new PlayerDataImplBukkit(playerId, firstJoin, lastJoin, lastSeen, afk, lastName, rank);
    }

    public List<OfflinePlayer> searchPlayersByPartialName(String partialName) throws SQLException {
        List idNamePairs = this.getPlayerIdsByPartialName(partialName);
        ArrayList<OfflinePlayer> result = new ArrayList<OfflinePlayer>(idNamePairs.size());
        for (Triple pair : idNamePairs) {
            CachedOfflinePlayer player = new CachedOfflinePlayer((UUID)pair.first, (String)pair.second, (Long)pair.third);
            result.add(player);
        }
        return result;
    }
}

