/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.InventoryInputManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryInputManagerImpl
implements InventoryInputManager,
Listener {
    private CubesideUtilsBukkit core = CubesideUtilsBukkit.getInstance();
    private Map<Player, InventoryInputData> pendingInputs = new HashMap<Player, InventoryInputData>();

    public InventoryInputManagerImpl() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.core.getPlugin());
    }

    @Override
    public void requestInventoryInput(Player player, Consumer<ItemStack[]> callback, Consumer<InventoryInputManager.InterruptCause> interruptHandler, ItemStack[] defaultContent) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)defaultContent.length);
        this.pendingInputs.put(player, new InventoryInputData(callback, interruptHandler, inventory));
        player.openInventory(inventory);
    }

    @Override
    public void cancelInventoryInput(Player player) {
        InventoryInputData data = this.pendingInputs.remove(player);
        if (player == null) {
            return;
        }
        data.interruptHandler().accept(InventoryInputManager.InterruptCause.CANCELLED);
    }

    @EventHandler
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        InventoryInputData data = this.pendingInputs.remove(event.getPlayer());
        if (data == null) {
            return;
        }
        if (!data.inventory().equals(event.getView().getTopInventory())) {
            data.interruptHandler.accept(InventoryInputManager.InterruptCause.OTHER_INVENTORY_CLOSED);
            return;
        }
        data.callback.accept(data.inventory().getContents());
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        InventoryInputData data = this.pendingInputs.remove(event.getPlayer());
        if (data == null) {
            return;
        }
        data.interruptHandler().accept(InventoryInputManager.InterruptCause.DISCONNECTED);
    }

    private record InventoryInputData(Consumer<ItemStack[]> callback, Consumer<InventoryInputManager.InterruptCause> interruptHandler, Inventory inventory) {
    }
}

