/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.conditions;

import de.iani.cubesideutils.bukkit.plugin.api.PlayerDataBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.UtilsApiBukkit;
import de.iani.cubesideutils.conditions.Condition;
import java.util.Objects;
import org.bukkit.OfflinePlayer;

public class HasCustomPlayerDataValueCondition
implements Condition<OfflinePlayer> {
    public static String SERIALIZATION_TYPE = "HasCustomPlayerDataValueCondition";
    private static final char SEPERATION_CHAR = '#';
    private String key;
    private String value;

    /*
     * Enabled aggressive block sorting
     */
    public static HasCustomPlayerDataValueCondition deserialize(String serialized) {
        int i;
        int parenthesis = 0;
        block5: for (i = 0; i < serialized.length(); ++i) {
            switch (serialized.charAt(i)) {
                case '(': {
                    ++parenthesis;
                    break;
                }
                case ')': {
                    --parenthesis;
                    break;
                }
                case '#': {
                    if (parenthesis == 0) break block5;
                }
            }
        }
        if (i >= serialized.length()) {
            throw new IllegalArgumentException("invalid syntax");
        }
        String key = Condition.unescape((String)serialized.substring(1, i - 1));
        String value = Condition.unescape((String)serialized.substring(i + 1));
        return new HasCustomPlayerDataValueCondition(key, value);
    }

    public HasCustomPlayerDataValueCondition(String key, String value) {
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
    }

    public boolean test(OfflinePlayer t) {
        PlayerDataBukkit data = UtilsApiBukkit.getInstance().getPlayerData(t);
        if (data == null) {
            return false;
        }
        return Objects.equals(data.getCustomData(this.key), this.value);
    }

    public String getSerializationType() {
        return SERIALIZATION_TYPE;
    }

    public String serializeToString() {
        return "(" + Condition.escape((String)this.key) + ")#" + Condition.escape((String)this.value);
    }
}

