/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.serialization;

import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.StringUtilCore;
import de.iani.cubesideutils.collections.GeneralHashMap;
import de.iani.cubesideutils.serialization.NullWrapper;
import de.iani.cubesideutils.serialization.StringSerializable;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;

public class StringSerialization {
    public static final int MAX_TYPE_NAME_LENGTH = 64;
    public static final String SERIALIZATION_TYPE_STRING = "STRING";
    public static final String SERIALIZATION_TYPE_BOOLEAN = "BOOLEAN";
    public static final String SERIALIZATION_TYPE_INTEGER = "INTEGER";
    public static final String SERIALIZATION_TYPE_LONG = "LONG";
    public static final String SERIALIZATION_TYPE_DOUBLE = "DOUBLE";
    private static final Pattern LEGAL_TYPE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9\\_]{1,64}");
    private static Map<String, Function<String, ?>> serializationTypes = new GeneralHashMap(StringUtilCore.CASE_IGNORING_HASHER, StringUtilCore.CASE_IGNORING_EQUALITY);

    public static synchronized void register(String serializationType, Function<String, StringSerializable> deserializer) {
        StringSerialization.registerInternal(serializationType, deserializer);
    }

    private static synchronized void registerInternal(String serializationType, Function<String, ?> deserializer) {
        if (!LEGAL_TYPE_NAME_PATTERN.matcher(serializationType).matches()) {
            throw new IllegalArgumentException("Name of serialization is illegal.");
        }
        Function<String, ?> old = serializationTypes.putIfAbsent(serializationType, deserializer);
        if (old != null) {
            throw new IllegalArgumentException("This serializationType is already registered!");
        }
    }

    public static Pair<String, String> serialize(Object arg) {
        if (arg == null) {
            return new Pair<String, String>("NULL", NullWrapper.INSTANCE.serializeToString());
        }
        if (arg instanceof StringSerializable) {
            StringSerializable s = (StringSerializable)arg;
            return new Pair<String, String>(s.getSerializationType(), s.serializeToString());
        }
        if (arg instanceof String) {
            String s = (String)arg;
            return new Pair<String, String>(SERIALIZATION_TYPE_STRING, s);
        }
        if (arg instanceof Boolean) {
            Boolean b = (Boolean)arg;
            return new Pair<String, String>(SERIALIZATION_TYPE_BOOLEAN, String.valueOf(b));
        }
        if (arg instanceof Integer) {
            Integer i = (Integer)arg;
            return new Pair<String, String>(SERIALIZATION_TYPE_INTEGER, String.valueOf(i));
        }
        if (arg instanceof Long) {
            Long x = (Long)arg;
            return new Pair<String, String>(SERIALIZATION_TYPE_LONG, String.valueOf(x));
        }
        if (arg instanceof Double) {
            Double d = (Double)arg;
            return new Pair<String, String>(SERIALIZATION_TYPE_DOUBLE, String.valueOf(d));
        }
        throw new ClassCastException(arg.getClass() + " neither implements StringSerializable nor is implicitely serializable to String.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserialize(String serializationType, String serialized) {
        Class<StringSerializable> clazz = StringSerializable.class;
        synchronized (StringSerializable.class) {
            Function<String, ?> deserializer = serializationTypes.get(serializationType);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (deserializer == null) {
                throw new IllegalArgumentException("Unknown serializationType " + serializationType + ".");
            }
            try {
                return (T)deserializer.apply(serialized);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception trying to deserialize type " + serializationType + " with serialized text: " + serialized, e);
            }
        }
    }

    private StringSerialization() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    static {
        StringSerialization.registerInternal("NULL", serialized -> null);
        StringSerialization.registerInternal(SERIALIZATION_TYPE_STRING, serialized -> serialized);
        StringSerialization.registerInternal(SERIALIZATION_TYPE_BOOLEAN, Boolean::parseBoolean);
        StringSerialization.registerInternal(SERIALIZATION_TYPE_INTEGER, Integer::parseInt);
        StringSerialization.registerInternal(SERIALIZATION_TYPE_LONG, Long::parseLong);
        StringSerialization.registerInternal(SERIALIZATION_TYPE_DOUBLE, Double::parseDouble);
    }
}

