/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.iani.cubesideutils.bukkit.plugin.CachedOfflinePlayer;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.OnlinePlayerDataImpl;
import de.iani.cubesideutils.bukkit.plugin.api.OnlinePlayerData;
import de.iani.cubesideutils.bukkit.plugin.api.PlayerDataBukkit;
import de.iani.cubesideutils.plugin.PlayerDataImpl;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PlayerDataImplBukkit
extends PlayerDataImpl
implements PlayerDataBukkit {
    public PlayerDataImplBukkit(UUID playerId, long firstJoin, long lastJoin, long lastSeen, boolean afk, String lastName, String rank) {
        super(playerId, firstJoin, lastJoin, lastSeen, afk, lastName, rank);
    }

    @Override
    public boolean isOnlineHere() {
        if (Bukkit.isPrimaryThread()) {
            return Bukkit.getPlayer((UUID)this.getPlayerId()) != null;
        }
        try {
            return (Boolean)Bukkit.getScheduler().callSyncMethod((Plugin)CubesideUtilsBukkit.getInstance().getPlugin(), () -> Bukkit.getPlayer((UUID)this.getPlayerId()) != null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OnlinePlayerDataImpl getOnlineData() {
        if (this instanceof OnlinePlayerData) {
            return (OnlinePlayerDataImpl)this;
        }
        if (Bukkit.isPrimaryThread() && !this.isOnlineHere()) {
            throw new IllegalStateException("The player isn't online.");
        }
        return CubesideUtilsBukkit.getInstance().getPlayerDataCache().getOnline(this.getPlayerId());
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return new CachedOfflinePlayer(this.getPlayerId(), this.getLastName(), this.getLastSeen());
    }

    public void checkRank(Permissible player) {
        String rank = null;
        for (String possible : CubesideUtilsBukkit.getInstance().getRanks()) {
            String permission = CubesideUtilsBukkit.getInstance().getPermission(possible);
            if (permission != null && !player.hasPermission(permission)) continue;
            rank = possible;
            break;
        }
        this.setRank(rank);
    }
}

