/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class EntityAccessCheckEvent
extends EntityEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Plugin caller;
    private List<Plugin> entityOwningPlugins;
    private List<Plugin> unmodifiableEntityOwningPlugins;

    public EntityAccessCheckEvent(@NotNull Entity entity, @NotNull Plugin caller) {
        super(entity);
        this.caller = caller;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public Plugin getCaller() {
        return this.caller;
    }

    public boolean isProtected() {
        return this.entityOwningPlugins != null && !this.entityOwningPlugins.isEmpty();
    }

    public void addProtectingPlugin(Plugin plugin) {
        if (this.entityOwningPlugins == null) {
            this.entityOwningPlugins = new ArrayList<Plugin>();
        }
        this.entityOwningPlugins.add(plugin);
    }

    @NotNull
    public List<Plugin> getProtectingPlugins() {
        if (this.entityOwningPlugins == null || this.entityOwningPlugins.isEmpty()) {
            return List.of();
        }
        if (this.unmodifiableEntityOwningPlugins == null) {
            this.unmodifiableEntityOwningPlugins = Collections.unmodifiableList(this.entityOwningPlugins);
        }
        return this.unmodifiableEntityOwningPlugins;
    }
}

