/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.io.IOException;
import java.io.InputStream;
import net.md_5.bungee.api.chat.BaseComponent;

public class FontUtil {
    public static final int BOOK_LINE_WIDTH = 110;
    private static byte[] charWidth = new byte[65536];

    public static boolean fitsSingleBookPage(BaseComponent ... text) {
        if (text == null) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        for (BaseComponent c : text) {
            sb.append(c.toLegacyText());
        }
        return FontUtil.fitsSingleBookPage(sb.toString());
    }

    public static boolean fitsSingleBookPage(String string) {
        return FontUtil.getBookLines(string) <= 14;
    }

    public static int getBookLines(String string) {
        return FontUtil.splitStringForLineWidth(FontUtil.trimTrailingNewlines(string), 110).length;
    }

    private static String trimTrailingNewlines(String string) {
        while (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String[] splitStringForLineWidth(String string, int availableWidth) {
        return FontUtil.wrapString(string, availableWidth).split("\n");
    }

    private static String wrapString(String string, int availableWidth) {
        int charactersInLine = FontUtil.getFittingCharacters(string, availableWidth);
        if (string.length() <= charactersInLine) {
            return string;
        }
        String thisLine = string.substring(0, charactersInLine);
        char firstRemainingCharacter = string.charAt(charactersInLine);
        boolean removeFirstRemainingChar = firstRemainingCharacter == ' ' || firstRemainingCharacter == '\n';
        String remaining = FontUtil.extractFormatingFromString(thisLine) + string.substring(charactersInLine + (removeFirstRemainingChar ? 1 : 0));
        return thisLine + "\n" + FontUtil.wrapString(remaining, availableWidth);
    }

    private static int getFittingCharacters(String string, int availableWidth) {
        int pos;
        int stringLength = string.length();
        int totalWidth = 0;
        int lastSpace = -1;
        boolean bold = false;
        for (pos = 0; pos < stringLength; ++pos) {
            char c = string.charAt(pos);
            switch (c) {
                case '\n': {
                    lastSpace = pos;
                    break;
                }
                case '\u00a7': {
                    char colorChar;
                    if (pos >= stringLength - 1 || !FontUtil.isFormatCharacter(colorChar = string.charAt(pos + 1))) break;
                    ++pos;
                    if (colorChar != 'l' && colorChar != 'L') {
                        if (colorChar != 'r' && colorChar != 'R' && !FontUtil.isFormatColor(colorChar)) break;
                        bold = false;
                        break;
                    }
                    bold = true;
                    break;
                }
                case ' ': {
                    lastSpace = pos;
                }
                default: {
                    totalWidth += FontUtil.getCharWidth(c) + (bold ? 1 : 0);
                }
            }
            if (c == '\n' || totalWidth > availableWidth) break;
        }
        return pos != stringLength && lastSpace != -1 && lastSpace < pos ? lastSpace : pos;
    }

    private static int getCharWidth(char c) {
        return charWidth[c];
    }

    private static boolean isFormatColor(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isFormatSpecialCharacter(char c) {
        return c >= 'k' && c <= 'o' || c >= 'K' && c <= 'O' || c == 'r' || c == 'R' || c == 'x' || c == 'X';
    }

    private static boolean isFormatCharacter(char c) {
        return FontUtil.isFormatColor(c) || FontUtil.isFormatSpecialCharacter(c);
    }

    private static String extractFormatingFromString(String string) {
        Object formatingString = "";
        int formatingInitialCharacter = -1;
        int stringLength = string.length();
        while ((formatingInitialCharacter = string.indexOf(167, formatingInitialCharacter + 1)) != -1) {
            if (formatingInitialCharacter >= stringLength - 1) continue;
            char colorCharacter = string.charAt(formatingInitialCharacter + 1);
            if (FontUtil.isFormatColor(colorCharacter)) {
                formatingString = "\u00a7" + colorCharacter;
                continue;
            }
            if (!FontUtil.isFormatSpecialCharacter(colorCharacter)) continue;
            formatingString = (String)formatingString + "\u00a7" + colorCharacter;
        }
        return formatingString;
    }

    static {
        try (InputStream is = FontUtil.class.getClassLoader().getResourceAsStream("char_sizes.bin");){
            is.read(charWidth);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

