/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.conditions;

import de.iani.cubesideutils.conditions.Condition;
import de.iani.cubesideutils.serialization.StringSerialization;
import java.util.Objects;

public class BinaryCombinedCondition<T>
implements Condition<T> {
    public static final String SERIALIZATION_TYPE = "BinaryCombinedCondition";
    private static final char SEPERATION_CHAR = '#';
    private BinaryBooleanOperation operation;
    private Condition<? super T> first;
    private Condition<? super T> second;

    public static <T> BinaryCombinedCondition<T> deserialize(String serialized) {
        int i;
        String operationString = null;
        String firstConditionString = null;
        String secondConditionString = null;
        for (i = 0; i < serialized.length(); ++i) {
            if (serialized.charAt(i) != '#') continue;
            operationString = serialized.substring(0, i);
            ++i;
            break;
        }
        int j = i;
        int parenthesis = 0;
        while (i < serialized.length()) {
            switch (serialized.charAt(i)) {
                case '(': {
                    ++parenthesis;
                    break;
                }
                case ')': {
                    --parenthesis;
                    break;
                }
                case '#': {
                    if (parenthesis != 0) break;
                    firstConditionString = serialized.substring(j + 1, i - 1);
                    j = i + 1;
                }
            }
            ++i;
        }
        if (parenthesis == 0) {
            secondConditionString = serialized.substring(j + 1, i - 1);
        }
        if (operationString == null || firstConditionString == null || secondConditionString == null) {
            throw new IllegalArgumentException("invalid syntax");
        }
        BinaryBooleanOperation operation = BinaryBooleanOperation.valueOf(operationString);
        String firstConditionType = firstConditionString.substring(0, firstConditionString.indexOf(35));
        String firstConditionSerialized = firstConditionString.substring(firstConditionString.indexOf(35) + 1);
        Condition first = (Condition)StringSerialization.deserialize(firstConditionType, firstConditionSerialized);
        String secondConditionType = secondConditionString.substring(0, secondConditionString.indexOf(35));
        String secondConditionSerialized = secondConditionString.substring(secondConditionString.indexOf(35) + 1);
        Condition second = (Condition)StringSerialization.deserialize(secondConditionType, secondConditionSerialized);
        return new BinaryCombinedCondition<T>(operation, first, second);
    }

    public BinaryCombinedCondition(BinaryBooleanOperation operation, Condition<? super T> first, Condition<? super T> second) {
        this.operation = Objects.requireNonNull(operation);
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
    }

    @Override
    public boolean test(T t) {
        return this.operation.apply(t, this.first, this.second);
    }

    @Override
    public String getSerializationType() {
        return SERIALIZATION_TYPE;
    }

    @Override
    public String serializeToString() {
        return this.operation.name() + "#(" + this.first.getSerializationType() + "#" + this.first.serializeToString() + ")#(" + this.second.getSerializationType() + "#" + this.second.serializeToString() + ")";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BinaryBooleanOperation {
        AND{

            @Override
            public <T> boolean apply(T t, Condition<? super T> first, Condition<? super T> second) {
                return first.test(t) && second.test(t);
            }
        }
        ,
        OR{

            @Override
            public <T> boolean apply(T t, Condition<? super T> first, Condition<? super T> second) {
                return first.test(t) || second.test(t);
            }
        }
        ,
        XOR{

            @Override
            public <T> boolean apply(T t, Condition<? super T> first, Condition<? super T> second) {
                return first.test(t) ^ second.test(t);
            }
        }
        ,
        NAND{

            @Override
            public <T> boolean apply(T t, Condition<? super T> first, Condition<? super T> second) {
                return !first.test(t) || !second.test(t);
            }
        }
        ,
        NOR{

            @Override
            public <T> boolean apply(T t, Condition<? super T> first, Condition<? super T> second) {
                return !first.test(t) && !second.test(t);
            }
        }
        ,
        XNOR{

            @Override
            public <T> boolean apply(T t, Condition<? super T> first, Condition<? super T> second) {
                return !(first.test(t) ^ second.test(t));
            }
        }
        ,
        IMPLY{

            @Override
            public <T> boolean apply(T t, Condition<? super T> first, Condition<? super T> second) {
                return !first.test(t) || second.test(t);
            }
        };


        public abstract <T> boolean apply(T var1, Condition<? super T> var2, Condition<? super T> var3);
    }
}

