/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.serialization;

import de.iani.cubesideutils.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class SerializablePair<T, S>
extends Pair<T, S>
implements ConfigurationSerializable {
    public SerializablePair(T first, S second) {
        super(first, second);
    }

    public SerializablePair(Pair<T, S> copyOf) {
        this(copyOf.first, copyOf.second);
    }

    public SerializablePair(Map<String, Object> serialized) {
        this(serialized.get("first"), serialized.get("second"));
    }

    @Override
    public <X> SerializablePair<X, S> setFirst(X first) {
        return new SerializablePair<X, Object>(first, this.second);
    }

    @Override
    public <X> SerializablePair<T, X> setSecond(X second) {
        return new SerializablePair<Object, X>(this.first, second);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        result.put("first", this.first);
        result.put("second", this.second);
        return result;
    }

    static {
        ConfigurationSerialization.registerClass(SerializablePair.class);
        ConfigurationSerialization.registerClass(SerializablePair.class, (String)"de.iani.cubesideutils.bukkit.SerializablePair");
    }
}

