/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Location;

public class StringUtil {
    public static final Pattern MATCH_COLOR_CODES = Pattern.compile("\\\u00a7[" + Arrays.stream(ChatColor.values()).map(ChatColor::getChar).map(String::valueOf).collect(Collectors.joining()) + "]", 2);
    private static final Set<Character> CHARS_ILLEGAL_IN_FILENAME;

    public static String capitalizeFirstLetter(String s, boolean replaceUnderscores) {
        char[] cap = s.toCharArray();
        boolean lastSpace = true;
        for (int i = 0; i < cap.length; ++i) {
            char c = cap[i];
            if (c == '_') {
                if (replaceUnderscores) {
                    c = ' ';
                }
                lastSpace = true;
            } else if (c >= '0' && c <= '9' || c == '(' || c == ')') {
                lastSpace = true;
            } else {
                c = lastSpace ? Character.toUpperCase(c) : Character.toLowerCase(c);
                lastSpace = false;
            }
            cap[i] = c;
        }
        return new String(cap);
    }

    public static String formatBlockLocationWithoutWorld(Location loc) {
        return loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static String convertColors(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char next;
            char current = text.charAt(i);
            if (current == '&' && i + 1 < len && (ChatColor.getByChar((char)(next = text.charAt(i + 1))) != null || next == '&')) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(text, 0, i);
                }
                ++i;
                if (next != '&') {
                    builder.append('\u00a7').append(next);
                    continue;
                }
            }
            if (builder == null) continue;
            builder.append(current);
        }
        return builder == null ? text : builder.toString();
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength) {
        return StringUtil.breakLines(text, lineLength, MATCH_COLOR_CODES);
    }

    public static List<String> breakLinesForMinecraft(String text, int lineLength, boolean forceLineBreak) {
        return StringUtil.breakLines(text, lineLength, MATCH_COLOR_CODES, forceLineBreak);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength) {
        return StringUtil.breakLines(text, lineLength, ignoreForLength, false);
    }

    public static List<String> breakLines(String text, int lineLength, Pattern ignoreForLength, boolean forceLineBreak) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentBuilder = new StringBuilder();
        char[] chars = text.toCharArray();
        int index = 0;
        int lastBlank = -1;
        int lastBreak = 0;
        while (index < chars.length) {
            char current = chars[index];
            if (current == ' ') {
                lastBlank = index;
            }
            currentBuilder.append(current);
            if (StringUtil.tooLong(currentBuilder.toString(), lineLength, ignoreForLength)) {
                if (lastBlank > lastBreak) {
                    int start = lastBlank - lastBreak;
                    int end = currentBuilder.length();
                    currentBuilder.delete(start, end);
                    result.add(currentBuilder.toString());
                    currentBuilder = new StringBuilder();
                    lastBreak = index = lastBlank + 1;
                    continue;
                }
                if (forceLineBreak) {
                    currentBuilder.delete(currentBuilder.length() - 1, currentBuilder.length());
                    result.add(currentBuilder.toString());
                    currentBuilder = new StringBuilder();
                    lastBreak = index;
                    continue;
                }
            }
            ++index;
        }
        if (currentBuilder.length() > 0) {
            result.add(currentBuilder.toString());
        }
        return result;
    }

    private static boolean tooLong(String string, int limit, Pattern ignoreForLength) {
        string = ignoreForLength == null ? string : ignoreForLength.matcher(string).replaceAll("");
        return string.length() > limit;
    }

    public static boolean isSafeFilename(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!CHARS_ILLEGAL_IN_FILENAME.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalCommandName(String name) {
        return !name.contains(" ");
    }

    static {
        HashSet<Character> illegals = new HashSet<Character>();
        for (char c = '\u0000'; c <= '\u001f'; c = (char)(c + '\u0001')) {
            illegals.add(Character.valueOf(c));
        }
        for (char c : new char[]{'|', '\\', '/', '?', '!', '*', '+', '%', '<', '>', '\"', ':', ';', ',', '.', '=', '[', ']', '@', '\u007f'}) {
            illegals.add(Character.valueOf(c));
        }
        CHARS_ILLEGAL_IN_FILENAME = Collections.unmodifiableSet(illegals);
    }
}

